% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proDSfit.R
\name{proDSfit}
\alias{proDSfit}
\title{Training of the evidential neural network classifier}
\usage{
proDSfit(x, y, param, lambda = 1/max(as.numeric(y)), mu = 0,
  optimProto = TRUE, options = list(maxiter = 500, eta = 0.1, gain_min =
  1e-04, disp = 10))
}
\arguments{
\item{x}{Input matrix of size n x d, where n is the number of objects and d the number of
attributes.}

\item{y}{Vector of class lables (of length n). May be a factor, or a vector of
integers from 1 to M (number of classes).}

\item{param}{Initial parameters (see \code{link{proDSinit}}).}

\item{lambda}{Parameter of the cost function. If \code{lambda=1}, the
cost function measures the error between the plausibilities and the 0-1 target values.
If \code{lambda=1/M}, where M is the number of classes (default), the piginistic probabilities
are considered in the cost function. If \code{lambda=0}, the beliefs are used.}

\item{mu}{Regularization hyperparameter (default=0).}

\item{optimProto}{Boolean. If TRUE, the prototypes are optimized (default). Otherwise, they are fixed.}

\item{options}{A list of parameters for the optimization algorithm: maxiter
(maximum number of iterations), eta (initial step of gradient variation),
gain_min (minimum gain in the optimisation loop), disp (integer; if >0, intermediate
results are displayed every disp iterations).}
}
\value{
A list with three elements:
  \describe{
  \item{param}{Optimized network parameters.}
  \item{cost}{Final value of the cost function.}
  \item{err}{Training error rate.}
 }
}
\description{
\code{proDSfit} performs parameter optimization for the evidential neural network classifier.
}
\details{
The prototypes are initialized by the k-means algorithms. The initial membership values \eqn{u_{ik}} of
each prototype \eqn{p_i} to class \eqn{\omega_k} are normally defined as the proportion of training samples
from class \eqn{\omega_k} in the neighborhood of prototype \eqn{p_i}. If arguments \code{crisp} and
\code{nprotoPerClass} are set to TRUE, the prototypes are assigned to one and only one class.
}
\examples{
## Glass dataset
data(glass)
xapp<-glass$x[1:89,]
yapp<-glass$y[1:89]
xtst<-glass$x[90:185,]
ytst<-glass$y[90:185]
## Initialization
param0<-proDSinit(xapp,yapp,nproto=7)
## Training
fit<-proDSfit(xapp,yapp,param0)
}
\references{
T. Denoeux. A neural network classifier based on Dempster-Shafer theory.
IEEE Trans. on Systems, Man and Cybernetics A, 30(2):131--150, 2000.

Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}
\seealso{
\code{\link{proDSinit}}, \code{\link{proDSval}}
}
\author{
Thierry Denoeux.
}
