% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inst_pkg.R
\name{inst_pkg}
\alias{inst_pkg}
\title{Install R Packages from Multiple Sources}
\usage{
inst_pkg(
  pkg = NULL,
  source = c("CRAN", "GitHub", "Bioconductor", "Local"),
  path = NULL,
  ...
)
}
\arguments{
\item{pkg}{Package name(s) or GitHub repo (e.g., "user/repo"). Not required for \code{source = "local"}.}

\item{source}{Source of package: "CRAN", "GitHub", "Bioconductor", "local". Case-insensitive, shorthand allowed.}

\item{path}{Path to local package file (used when \code{source = "local"}).}

\item{...}{Additional arguments passed to \code{install.packages()}, \code{devtools::install_github()}, or \code{BiocManager::install()}.}
}
\value{
NULL (invisibly)
}
\description{
A unified installer for R packages from CRAN, GitHub, Bioconductor, or local source.
}
\examples{
\dontrun{
# Install from CRAN:
inst_pkg("dplyr", source = "CRAN")

# Install from GitHub:
inst_pkg("hadley/emo", source = "GitHub")

# Install from Bioconductor:
inst_pkg("scRNAseq", source = "Bioconductor")

# Install from local file:
inst_pkg(source = "local", path = "mypackage.tar.gz")
}

\donttest{
# Quick demo - try to install a small package (will skip if already installed):
try(inst_pkg("praise", source = "CRAN"))
}
}
