% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{read_qualitative_inputs}
\alias{read_qualitative_inputs}
\title{Load qualitative inputs}
\usage{
read_qualitative_inputs(input_directory = "~/evaluator/inputs")
}
\arguments{
\item{input_directory}{Location of input files.}
}
\value{
List of domains, mappings, capabilities, and qualitative_scenarios
}
\description{
Given an input directory, load the key qualitative objects into memory.
}
\details{
The key qualitative inputs for Evaluator processing include:
\itemize{
\item \code{domains.csv}: domains and domain_ids
\item \code{mappings.csv}: qualitative to quantitative mappings
\item \code{capabilities.csv}: qualitative capabilities
\item \code{qualitative_scenarios.csv}: qualitative risk scenarios
}
}
\examples{
\dontrun{
read_qualitative_inputs("~/evaluator/inputs")
}
}
