% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{risk_dashboard}
\alias{risk_dashboard}
\title{Launch a single page summary risk dashboard}
\usage{
risk_dashboard(input_directory = "~/evaluator/inputs",
  results_directory = "~/evaluator/results", output_file,
  intermediates_dir = tempdir(), quiet = TRUE, ...)
}
\arguments{
\item{input_directory}{Location of input files.}

\item{results_directory}{Location of simulation results.}

\item{output_file}{Full path to the desired output file.}

\item{intermediates_dir}{Location for intermediate knit files.}

\item{quiet}{\code{TRUE} to suppress printing of pandoc output.}

\item{...}{Any other parameters to pass to \code{rmarkdown::render}}
}
\value{
Default return values of the \code{rmarkdown::render} function.
}
\description{
Given the input files and the analysis summary file, create a basic one-
page summary with an overview of the results per domain and scenario.
Intended as a skeleton showing how the results could be displayed at an
executive level.
}
\examples{
\dontrun{
risk_dashboard("~/inputs", "~/simulations")
}
}
