% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva.R
\name{\%IN\%}
\alias{\%IN\%}
\title{Returns the common columns}
\usage{
x \%IN\% y
}
\arguments{
\item{x}{data.frame}

\item{y}{data.frame or character string}
}
\value{
data.frame with common columns or a cropped SpatRaster
}
\description{
results of 'd01 in d02' style syntax
}
\note{
a message is always displayed to keep easy to track and debug issues (with the results and the evaluation process).

can be used to crop rast objects, such as arguments of sat() function
}
\examples{
times <- seq(as.POSIXct('2024-01-01',tz = 'UTC'),
             as.POSIXct('2024-01-02',tz = 'UTC'),
             by = 'hour')
randon_stuff <- rnorm(25,10)

observation <- data.frame(date   = times,
                          site_1 = randon_stuff,
                          site_3 = randon_stuff,
                          site_4 = randon_stuff,
                          site_5 = randon_stuff,
                          site_6 = randon_stuff,
                          site_7 = randon_stuff)

model_d01 <- data.frame(date  = times,
                        site_1=randon_stuff+1,
                        site_2=randon_stuff+2,
                        site_3=randon_stuff+3,
                        site_4=randon_stuff+4)

model_d02 <- data.frame(date  = times,
                        site_1=randon_stuff-1,
                        site_3=randon_stuff-3)

# multiline
model_d01_in_d02 <- model_d01 \%IN\% model_d02
eva(mo = model_d01_in_d02, ob = observation, rname = 'd01 in d02')

# or single line
eva(mo = model_d01 \%IN\% model_d02, ob = observation, rname = 'd01 in d02')
# or
eva(mo = model_d01, ob = observation \%IN\% model_d02, rname = 'd01 in d02')

}
