% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevrEd.R
\name{gevrEd}
\alias{gevrEd}
\title{GEVr Entropy Difference Test}
\usage{
gevrEd(data, theta = NULL)
}
\arguments{
\item{data}{Data should be contain n rows, each a GEVr observation.}

\item{theta}{Estimate for theta in the vector form (loc, scale, shape). If NULL, uses the MLE from the full data.}
}
\value{
\item{statistic}{Test statistic.}
\item{p.value}{P-value for the test.}
\item{theta}{Estimate of theta using the top r order statistics.}
}
\description{
Goodness-of-fit test for GEVr using the difference in likelihood between GEVr and GEV(r-1).
This can be used sequentially to test for the choice of r.
}
\details{
GEVr data (in matrix x) should be of the form \eqn{x[i,1] > x[i, 2] > \cdots > x[i, r]} for each
observation \eqn{i = 1, \ldots, n}. The test uses an asymptotic normality result based on the expected
entropy between the GEVr and GEV(r-1) likelihoods. See reference for detailed information. This test can be
used to sequentially test for the choice of r, implemented in the function `gevrSeqTests'.
}
\examples{
## This will test if the GEV2 distribution fits the data.
x <- rgevr(100, 2, loc = 0.5, scale = 1, shape = 0.5)
result <- gevrEd(x)
}
\references{
Bader B., Yan J., & Zhang X. (2015). Automated Selection of r for the r Largest Order Statistics Approach with Adjustment for Sequential Testing. Department of Statistics, University of Connecticut.
}

