% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gpdRl.R
\name{gpdRl}
\alias{gpdRl}
\title{GPD Return Level Estimate and Confidence Interval}
\usage{
gpdRl(z, period, conf = 0.95, method = c("delta", "profile"),
  opt = c("Nelder-Mead", "SANN", "BFGS", "CG", "L-BFGS-B", "Brent"))
}
\arguments{
\item{z}{An object of class gpdFit.}

\item{period}{The number of periods to use for the return level.}

\item{conf}{Confidence level. Defaults to 95 percent.}

\item{method}{The method to compute the confidence interval - either delta method (default) or profile likelihood.}

\item{opt}{Optimization method to maximize the profile likelihood if that is selected. Argument passed to optim. The default method is Nelder-Mead.}
}
\value{
\item{Estimate}{Estimated m-period return level.}
\item{CI}{Confidence interval for the m-period return level.}
\item{Period}{The period length used.}
\item{ConfLevel}{The confidence level used.}
}
\description{
Computes m-period return level estimate and interval for the generalized pareto distribution, using either the delta method or profile likelihood.
}
\details{
Caution: The profile likelihood optimization may be slow for large datasets.
}
\examples{
x <- rgpd(5000, loc = 0, scale = 1, shape = 0.1)
## Compute 50-period return level.
z <- gpdFit(x, nextremes = 200)
gpdRl(z, period = 50, method = "delta")
gpdRl(z, period = 50, method = "profile")
}
\references{
Coles, S. (2001). An introduction to statistical modeling of extreme values (Vol. 208). London: Springer.
}

