% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gevrMultScore.R
\name{gevrMultScore}
\alias{gevrMultScore}
\title{GEVr Multiplier Score Test}
\usage{
gevrMultScore(data, B, theta = NULL, information = c("expected",
  "observed"))
}
\arguments{
\item{data}{Data should be contain n rows, each a GEVr observation.}

\item{B}{Number of bootstrap replicates.}

\item{theta}{Estimate for theta in the vector form (loc, scale, shape). If NULL, an initial estimate is provided.}

\item{information}{To use expected (default) or observed information in the test.}
}
\value{
statistic Test statistic.

p.value P-value for the test.

theta Value of theta used in the test.
}
\description{
Fast weighted bootstrap alternative to the parametric bootstrap procedure for the GEVr score test.
}
\details{
GEVr data (in matrix x) should be of the form \eqn{x[i,1] > x[i, 2] > \cdots > x[i, r]} for each observation \eqn{i = 1, \ldots, n}.
}
\examples{
x <- rgevr(500, 5, loc = 0.5, scale = 1, shape = 0.3)
result <- gevrMultScore(x, 1000)
}
\references{
Bader B., Jun Y., & Zhang X. (2015). Automated Selection of r for the r Largest Order Statistics Approach with Adjustment for Sequential Testing. Department of Statistics, University of Connecticut.
}

