% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{ComputeB1Exp}
\alias{ComputeB1Exp}
\title{Wrapper to compute difference area between \code{t2} and \code{t1}
under exponential trawl function.}
\usage{
ComputeB1Exp(rho, t1, t2)
}
\arguments{
\item{rho}{Exponential trawl parameter (should be non-negative).}

\item{t1}{First timestamp.}

\item{t2}{Second timestamp.}
}
\value{
Difference area between \code{t1} and \code{t2}
under exponential trawl function. Relies on ComputeB3Exp.
}
\description{
Wrapper to compute difference area between \code{t2} and \code{t1}
under exponential trawl function.
}
\examples{
ComputeB1Exp(1, t1 = 3, t2 = 5)
ComputeB1Exp(0.2, t1 = 7, t2 = 3)

}
