% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medianheuristic.R
\name{mediandiff}
\alias{mediandiff}
\title{Compute the median difference}
\usage{
mediandiff(X, Y = NULL, kernel = c("Laplacian", "Gaussian"), fast = FALSE)
}
\arguments{
\item{X}{Numeric vector or matrix of length \code{n}.}

\item{Y}{Numeric vector or matrix of length \code{m}, or \code{NULL}.}

\item{kernel}{String, either \code{"Laplacian"} or \code{"Gaussian"}.}

\item{fast}{Boolean; if \code{TRUE} will run \code{O(N log N)} algorithm,
where \code{N = n + m},
but if \code{FALSE} will run naive \code{O(N^2 log(N))} algorithm.}
}
\value{
a scalar, the median of all pairwise differences.
}
\description{
Compute the median difference out of all differences between distinct
pairs in vectors or matrices.
}
\details{
The median difference is defined as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{     Z is the combined X and Y values into a single vector.matrix.
     Number of columns is the dimension, and these need to be equal 
     for X and Y. Then
}\if{html}{\out{</div>}}

\code{ m = median { ||z_i - z_j||_1; i=1, 2, ..., n+m, and j=1, 2,..., i } },

\if{html}{\out{<div class="sourceCode">}}\preformatted{     where \code{||z_i - z_j||_1} is the 1-norm, and so if the data 
     are \code{d}-dimensional then
     
     \code{ ||z_i - z_j||_1 = \sum_{k=1}^{d} |z_{i,k} - z_{j,k}| },
     
    The median heuristic is defined as \code{beta = 1/m}.
     
    Naive method will compute all distinct pairs, of which there are 
    \code{N(N+1)/2} differences. These are then sorted using 
    a O(N log(N)) algorithm, so overall \code{O(N^2 log(N))}. 

    The fast method is \code{O(N log N)} is from Croux and Rousseeuw (1992), 
    which is based on Johnson and Mizoguchi (1978). 
}\if{html}{\out{</div>}}
}
\examples{

X <- c(7.1, 1.2, 4.3, 0.4)
Y <- c(5.5, 2.6, 8.7)
md <- mediandiff(X, Y, fast=TRUE)

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    Croux, C. and Rousseeuw, P. J. (1992), 
    "Time-Efficient Algorithms for Two Highly Robust Estimators of Scale"
    In Computational Statistics: Volume 1: Proceedings of the 10th 
    Symposium on Computational Statistics (pp. 411-428).

    Johnson, D.B., and Mizoguchi, T. (1978), 
    "Selecting the Kth Element in X + Y and X_1 + X_2 + ... + X_m", 
    SIAM Journal of Computing, 7, 147-153.
}\if{html}{\out{</div>}}
}
\seealso{
medianheuristic
}
