% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market.R
\name{etrd_product_search}
\alias{etrd_product_search}
\title{Product Search}
\usage{
etrd_product_search(
  search = "tech",
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{search}{The search request}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a Data frame of the search results
}
\description{
Returns a list of securities of a specified type (e.g., equity stock) based
on a full or partial match of any part of the company name. For instance, a
search for "jones" returns a list of securities associated with "Jones Soda
Co", "Stella Jones Inc", and many others. The list contains the company name,
the exchange that lists the security, the security type, and the symbol, for
up to 10 matches. The result may include some unexpected matches, because the
search includes more than just the display version of the company name. For
instance, searching on "etrade" returns securities for "E TRADE" - notice the
space in the name. This API is for searching on the company name, not a
security symbol. It's commonly used to look up a symbol based on the company
name, e.g., "What is the symbol for Google stock?". To look up company
information based on a symbol, or to find detailed information on a security,
use the quote API.
}
\examples{
\dontrun{

# search for tech firms
etrd_product_search('tech')

}
}
