% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{probs}
\alias{probs}
\title{Compute probabilities from the empirical CDFs of a grouping variable for
each group.}
\usage{
probs(formula, data, center = FALSE)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{center}{Logical. Should the functions be centered prior to plotting?}
}
\value{
A matrix of probabilities with separate columns for each group and
\code{rownames} corresponding to the value the paired probabilities are 
calculated from.
}
\description{
This formula returns the paired probabilities for any
}
\examples{
probs(math ~ condition, star)
}
