% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngamma.R
\name{sar}
\alias{sar}
\title{A Markov Chain Monte Carlo (MCMC) sampler for the panel spatial autoregressive model (SAR) with exogenous spatial weight matrix.}
\usage{
sar(
  Y,
  tt,
  W,
  Z = matrix(1, nrow(Y), 1),
  niter = 200,
  nretain = 100,
  rho_prior = rho_priors(),
  beta_prior = beta_priors(k = ncol(Z)),
  sigma_prior = sigma_priors()
)
}
\arguments{
\item{Y}{numeric \eqn{N \times 1} matrix containing the dependent variables, where \eqn{N = nT} is the number of
spatial (\eqn{n}) times the number of time observations (\eqn{T}, with \code{tt=T}). Note that the observations
have organized such that \eqn{Y = [Y_1',...,Y_T']'}.}

\item{tt}{single number greater or equal to 1. Denotes the number of time observations. \eqn{tt = T}.}

\item{W}{numeric, non-negative and row-stochastic \eqn{n} by \eqn{n} exogenous spatial weight matrix.
Must have zeros on the main diagonal.}

\item{Z}{numeric \eqn{N \times k_3} design matrix of independent variables.
The default value is a \eqn{N \times 1} vector of ones (i.e. an intercept for the model).}

\item{niter}{single number greater or equal to 1, indicating the total number of draws.
Will be automatically coerced to integer. The default value is 200.}

\item{nretain}{single number greater or equal to 0, indicating the number of draws
kept after the burn-in. Will be automatically coerced to integer. The default value is 100.}

\item{rho_prior}{list of prior settings for estimating \eqn{\rho},
generated by the smart constructor \code{\link{rho_priors}}}

\item{beta_prior}{list containing priors for the slope coefficients,
generated by the smart constructor \code{\link{beta_priors}}.}

\item{sigma_prior}{list containing priors for the error variance \eqn{\sigma^2},
generated by the smart constructor \code{\link{sigma_priors}}}
}
\description{
The sampler uses independent Normal-inverse-Gamma priors for the slope and variance parameters,
as well as a four-parameter beta prior for the spatial autoregressive parameter \eqn{\rho}. The function is
used as an illustration on using the \code{\link{beta_sampler}}, \code{\link{sigma_sampler}},
and \code{\link{rho_sampler}} classes.
}
\details{
The considered panel spatial autoregressive model (SAR) takes the form:

\deqn{
 Y_t = \rho W Y_t + Z_t \beta + \varepsilon_t,
 }

with \eqn{\varepsilon_t \sim N(0,I_n \sigma^2)}. The row-stochastic \eqn{n} by \eqn{n} spatial weight
matrix \eqn{W} is non-negative and has zeros on the main diagonal. \eqn{\rho} is a scalar spatial autoregressive parameter.

\eqn{Y_t} (\eqn{n \times 1}) collects the \eqn{n} cross-sectional (spatial) observations for time
\eqn{t=1,...,T}. \eqn{Z_t} (\eqn{n \times k_3}) is a matrix of explanatory variables.
\eqn{\beta} (\eqn{k_3 \times 1}) is an unknown slope parameter matrix.

After vertically staking the \eqn{T} cross-sections  \eqn{Y=[Y_1',...,Y_T']'} (\eqn{N \times 1}),
\eqn{Z=[Z_1',...,Z_T']'} (\eqn{N \times k_3}), with \eqn{N=nT}, the final model can be expressed as:

\deqn{
 Y = \rho \tilde{W}Y + Z \beta + \varepsilon,
}

where \eqn{\tilde{W}=I_T \otimes W} and \eqn{\varepsilon \sim N(0,I_N \sigma^2)}. Note that the input
data matrices have to be ordered first by the cross-sectional spatial units and then stacked by time.
This is a wrapper function calling \code{\link{sdm}} with no spatially lagged dependent variables.
}
\examples{
n = 20; tt = 10
dgp_dat = sim_dgp(n =n, tt = tt, rho = .5, beta3 = c(1,.5), sigma2 = .5)
res = sar(Y = dgp_dat$Y,tt = tt, W = dgp_dat$W,
          Z = dgp_dat$Z,niter = 100,nretain = 50)
}
