% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_closing.R
\name{bin.closing}
\alias{bin.closing}
\title{Binary volume closing}
\usage{
bin.closing(vol, radius = 10, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object, of "binary" modality}

\item{radius}{Positive number, in millimeters. By default, radius = 10.}

\item{alias}{Character string, \code{$object.alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (vol$object.alias, "closing r =", radius)}.}
}
\value{
Returns a "volume" class object of "binary" modality
(see \link[espadon]{espadon.class} for class definitions),  with the same grid
as \code{vol}, in which \code{$vol3D.data} has been transformed  by the closing
operation.
}
\description{
The \code{bin.closing} function performs a morphological
operation of closing, using a sphere, on a "volume" class object of "binary" modality.
Closing is useful for :
\itemize{
\item filling holes that are smaller than the \code{radius},
\item merging two shapes close to each other.
}
}
\note{
Closing can be time consuming, try to reduce the \code{binary}
volume to the strict minimum, before any operations.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = "mr", roi.name = "", 
                             dxyz = rep (step, 3))
MR <- patient$mr[[1]]

# generation of a binary volume
b <- bin.from.vol(MR, min = 15, max = 30)

b.closing <- bin.closing (b, radius = step)
display.plane (bottom = MR, top = b, main = "Before closing", 
               view.coord = -20, interpolate = FALSE)
display.plane (bottom = MR, top = b.closing, main = "After closing", 
               view.coord = -20, interpolate = FALSE)
}
\seealso{
\link[espadon]{bin.dilation}, \link[espadon]{bin.erosion},
\link[espadon]{bin.opening}, \link[espadon]{add.margin}, \link[espadon]{nesting.cube}.
}
