% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevantREFVN.R
\name{relevantREFVN}
\alias{relevantREFVN}
\title{relevantREFVN}
\usage{
relevantREFVN(ID = NULL, IMEI = NULL, ST = NULL, STARTDATE = NULL,
  STARTTIME = NULL, ENDDATE = NULL, ENDTIME = NULL,
  START_DATETIME = NULL, END_DATETIME = NULL)
}
\arguments{
\item{ID}{a character string that specifies the column name which holds the unique identification code for the participant.}

\item{IMEI}{a character string. Column name that specifies the variable in the respective dataset holding the the IMEI number.}

\item{ST}{a character string. It must be the first component of the column name in the reference dataset that specifies the prompts on the mobile device, e.g. ST for scheduled time. The column names must all be equal except for the last character, which must specify the respective number of the prompt, e.g. ST3 for the third prompt of the day.}

\item{STARTDATE}{a character string that specifies the column name in the respective dataset holding the date of when the participant started ... see \strong{Details}.}

\item{STARTTIME}{a character string that specifies the column name in the respective dataset holding the time of when the participant started ... see \strong{Details}.}

\item{ENDDATE}{a character string that specifies the column name in the respective dataset holding the date of when the participant ended ... see \strong{Details}.}

\item{ENDTIME}{a character string that specifies the column name in the respective dataset holding the time of when the participant ended ... see \strong{Details}.}

\item{START_DATETIME}{a character string. If \code{STARTDATE} and \code{STARTTIME} are not in two separate columns but are combined as a date-time object in a single column pass that column's name and ignore the arguments \code{STARTDATE} and \code{STARTTIME}.}

\item{END_DATETIME}{a character string. If \code{ENDDATE} and \code{ENDTIME} are not in two separate columns but are combined as a date-time object in a single column pass that column's name and ignore the arguments \code{ENDDATE} and \code{ENDTIME}.}
}
\value{
A list of the relevant variable/column names in the reference dataset. To be used as the last argument in the function \code{\link{setREF}}. The last element of the list is a logical value indicating whether the date and time are either separated (TRUE) or a single date-time object (FALSE). It is meaningful only for the subsequent function \code{\link{setREF}}.
}
\description{
relevantREFVN creates a list of the relevant variable names (VN) of the reference (REF) dataset.
}
\details{
The relevant variable names (i.e. column names) must refer to the reference dataset. The date and time of both start and end refers to the ESM period for each participant, starting with the date and time he/she fills out the very first ESM questionnaire on his/her own and ending with the date and time he/she fills out the very last ESM questionnaire.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# ------------------------------------------------------
# Run function 1 of 28; see esmprep functions' hierarchy.
# ------------------------------------------------------
# With date and time as separate arguments
relRef <- relevantREFVN(ID="id", IMEI="imei", ST="st",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
# With date-time objects instead of separate date and time
relRef <- relevantREFVN(ID="id", IMEI="imei", ST="st",
START_DATETIME="start_dateTime", END_DATETIME="end_dateTime")
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 1 of 28).
}
