% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_probabilities.R
\name{calculate_probabilities}
\alias{calculate_probabilities}
\title{Calculate dose-path probabilities}
\usage{
calculate_probabilities(dose_paths, true_prob_tox)
}
\arguments{
\item{dose_paths}{Object of type \code{\link{dose_paths}}}

\item{true_prob_tox}{Numeric vector, true probability of toxicity.}
}
\description{
Crystallise a set of \code{\link{dose_paths}} with probabilities to calculate
how likely each path is. Once probabilised in this way, the probabilities of
the terminal nodes in this set of paths will sum to 1. This allows users to
calculate operating characteristics.
}
\examples{
# Calculate dose paths for the first three cohorts in a 3+3 trial of 5 doses:
paths <- get_three_plus_three(num_doses = 5) \%>\%
  get_dose_paths(cohort_sizes = c(3, 3, 3))

# Set the true probabilities of toxicity
true_prob_tox <- c(0.12, 0.27, 0.44, 0.53, 0.57)
# And calculate exact operating performance
x <- paths \%>\% calculate_probabilities(true_prob_tox)
prob_recommend(x)
}
\seealso{
\code{\link{dose_paths}}
}
