% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esaps_object.R
\name{esaps_object}
\alias{esaps_object}
\title{Create an object of class esaps}
\usage{
esaps_object(path = NULL, dataset = NULL, name.file = NULL,
  extention = NULL, nCountry = NULL, name.year, name.country,
  name.M = NULL)
}
\arguments{
\item{path}{Character vector containing one or more path names.}

\item{dataset}{Electoral results by party. It can be a \code{matrix}, a
\code{data.frame} or a \code{list}.}

\item{name.file}{Name of the database file.}

\item{extention}{Extension of the database format.}

\item{nCountry}{Number of countries (number of sheets).}

\item{name.year}{Name of the variable that contains years.}

\item{name.country}{Name of the variable that contains the country.}

\item{name.M}{Name of the variable that contains the district magnitude
(M+1). It is for the calculation of endogenous and exogenous
electoral volatility (Torcal and Lago, 2015).}
}
\description{
Create an object of \code{esaps} class to calculate party system indicators.
}
\examples{
votes <- list(data.frame(country = rep("ARG", 3),
                         year = c(1995, 2000, 2005),
                         party_A = c(40,10,20),
                         party_B = c(35,20,40),
                         party_C = c(25,70,40)),
              data.frame(country = rep("URY", 4),
                         year = c(1995, 2000, 2005, 2010),
                         party_A = c(30,30,20,20),
                         party_B = c(30,50,40, 30),
                         party_C = c(30,10,30, 25),
                         party_D = c(10,10,10,25)),
              data.frame(country = rep("BRA", 2),
                         year = c(1993, 1998),
                         party_A = c(30, 55),
                         party_B = c(70, 45)))

votes <- esaps_object(dataset=votes, name.country="country", name.year="year")
is(votes, "esaps")    ## TRUE
}
