% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_R_ww.R
\name{inc2R_one_iter}
\alias{inc2R_one_iter}
\title{Helper function.
Converts wastewater to Rt after sampling one fecal shedding and
one generation interval distribution.}
\usage{
inc2R_one_iter(
  i,
  dist.fec,
  dist.gi,
  ww.conc,
  scaling.factor,
  prm.R,
  silent,
  RL.max.iter
)
}
\arguments{
\item{i}{Numeric. Iteration index. (not used but required when using
\code{lapply()})}

\item{dist.fec}{List. Parameters for the fecal shedding distribution in the same format as returned by \code{\link[=def_dist_fecal_shedding]{def_dist_fecal_shedding()}}.}

\item{dist.gi}{List. Parameters for the generation interval distribution in the same format as returned by \code{\link[=def_dist_generation_interval]{def_dist_generation_interval()}}.}

\item{ww.conc}{Data frame. Must have variables:
\itemize{
\item \code{date}: calendar date of wastewater collection
\item \code{value}: pathogen concentration
}}

\item{scaling.factor}{Numeric. Scaling from wastewater concentration to
prevalence. This value may be assumed or independently calibrated to data.}

\item{prm.R}{List. Settings for the ensemble when calculating Rt.
Elements include:
\itemize{
\item \code{iter}: Integer. Number of iterations for the Rt ensemble
\item \code{CI}: Numeric between 0 and 1. Confidence interval width for Rt
estimates after sampling uncertain distributions.
\item \code{window}: Integer. Number of days defining the window of data used by
\code{EpiEstim} to estimate Rt. If \code{NULL}, will default to 7.
\item \code{config.EpiEstim}: (optional) configuration for \code{EpiEstim} defined via
\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}. If \code{NULL}, will use default config from
\code{EpiEstim}.
}}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}

\item{RL.max.iter}{Integer. Maximum of iterations for the Richardson-Lucy deconvolution algorithm.}
}
\value{
List. Elements include \code{inc} (incidence) and \code{rt}
(reproduction number)
}
\description{
Helper function.
Converts wastewater to Rt after sampling one fecal shedding and
one generation interval distribution.
}
\keyword{internal}
