% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-terms-index.R
\name{search.ergmProposals}
\alias{search.ergmProposals}
\title{Search the ERGM Proposals}
\usage{
search.ergmProposals(search, name, reference, constraints, packages)
}
\arguments{
\item{search}{optional character search term to search for in the text of the
term descriptions. Only matching terms will be returned. Matching is case
insensitive.}

\item{name}{optional character name of a specific proposal to return}

\item{reference}{optional character to limit proposals to only those with a matching reference}

\item{constraints}{optional character vector to limit proposals to only those with matching hard or soft constraints}

\item{packages}{optional character vector indicating the subset of packages in which to search}
}
\value{
prints out the name and short description of matching terms, and
invisibly returns them as a list.  If \code{name} is specified, prints out
the full definition for the named term.
}
\description{
Searches through the \code{\link{ergm.proposals}} help page and prints out a
list of proposals appropriate for the specified network's structural
constraints, optionally restricting by additional keywords and search term
matches.
}
\details{
Uses \code{\link{grep}} internally to match the search terms against the proposal
description, so \code{search} is currently matched as a single phrase.
Keyword tags will only return a match if all of the specified tags are
included in the proposal
}
\examples{
\donttest{
# find all of the proposals that mention triangles
search.ergmProposals('MH algorithm')

# print out the content for a specific proposals
search.ergmProposals(name='randomtoggle')

# find all proposals with required or optional constraints
search.ergmProposals(constraints='.dyads')

# find all proposals with references
search.ergmProposals(reference='Bernoulli')

# request proposals that mention triangle in the ergm package
search.ergmProposals('MH algorithm', packages='ergm')
}
}
\seealso{
See also \code{\link{ergm.proposals}} for the complete documentation
}
