movie <- bechdel[1, ]
movies <- bechdel[2:4, ]

epoxy("*{movie$title}* ({movie$year}) was directed by {movie$director}.")
epoxy("- *{movies$title}* ({movies$year}) was directed by {movies$director}.")

epoxy("*{title}* ({year}) was directed by {director}.", .data = movie)
epoxy("- *{title}* ({year}) was directed by {director}.", .data = movies)

epoxy(
  "{title} ({year}) was directed by {director}.",
  .data = movie,
  .transformer = "bold"
)

epoxy(
  "I'd be happy to watch { title| }.",
  .data = movies,
  .transformer = c("italic", "collapse")
)

epoxy(
  "They were directed by { director& }.",
  .data = movies,
  .transformer = c("collapse", "bold")
)

epoxy("The budget for *{title}* was {.dollar budget}.", .data = movie)

epoxy_html(
  "I'd be happy to watch {{ title| }}.",
  .data = movies,
  .transformer = c("italic", "collapse")
)

epoxy_latex(
  "I'd be happy to watch < title| >.",
  .data = movies,
  .transformer = c("italic", "collapse")
)
