% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doThePlotDrugVectors.R
\name{createTanimotoBaseline}
\alias{createTanimotoBaseline}
\title{Creates the plot for all jaccard coefficients amongst the three epilepsy ontologies}
\usage{
createTanimotoBaseline(neuroepso, neuroesso, neuroepi, dneuromaxk)
}
\arguments{
\item{neuroepso}{list of neuro drug names co-occurring with epso}

\item{neuroesso}{list of neuro drug names co-occurring with esso}

\item{neuroepi}{list of neuro drug names co-occurring with epi}

\item{dneuromaxk}{object returned from TopKLists::calculate.maxk}
}
\value{
jaccardepilepsyplot the ggplot object
}
\description{
Creates the plot for all jaccard coefficients amongst the three epilepsy ontologies
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
atchashda <-
  readAtcMapIntoHashMapDrugNamesAtcCodes(
    system.file("extdata", "db-atc.map", package = "epos"), "\t")
tepso <- genDictListFromRawFreq(rawDrugNamesCoOcEpSO[1:150])
neuroepso <- filterNeuroDrugs(tepso, atchashda)
utils::data(rawDrugNamesCoOcESSO, package="epos")
tesso <- genDictListFromRawFreq(rawDrugNamesCoOcESSO[1:150])
neuroesso <- filterNeuroDrugs(tesso, atchashda)
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
tepi <- genDictListFromRawFreq(rawDrugNamesCoOcEPILONT[1:150])
neuroepi <- filterNeuroDrugs(tepi, atchashda)
dneuro <-
  data.frame(EpSO = neuroepso[1:9],
             ESSO = neuroesso[1:9],
             EPILONT = neuroepi[1:9])
dneuromaxk <- TopKLists::calculate.maxK(dneuro, 3, 5, 10)
tanimotobaseline <- createTanimotoBaseline(neuroepso, neuroesso, neuroepi, dneuromaxk)
}
