% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{read_idfeditor_copy}
\alias{read_idfeditor_copy}
\title{Parse objects from IDF Editor}
\usage{
read_idfeditor_copy(idd_env, idf_env, version = NULL, in_ip = FALSE)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{version}{The version of IDF file open by IDF Editor, e.g. \code{8.6},
\code{"8.8.0"}. If \code{NULL}, assume that the file has the same
version as current Idf object. Default: \code{NULL}.}

\item{in_ip}{Set to \code{TRUE} if the IDF file is open with \code{Inch-Pound}
view option toggled. Numeric values will automatically
converted to SI units if necessary. Default: \code{FALSE}.}
}
\value{
The copyied object data from IDF Editor in a named list of 3
\code{\link[data.table:data.table]{data.table::data.table()}}s, i.e. \code{object}, \code{value} and \code{reference}.
}
\description{
Parse objects from IDF Editor
}
\note{
References in the input is not parsed and \code{reference} in the returned list is
always a zero-row table.
}
\keyword{internal}
