% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{EPMacro}
\alias{EPMacro}
\alias{ExpandObjects}
\alias{Basement}
\alias{Slab}
\alias{EnergyPlus}
\alias{convertESOMTR}
\alias{ReadVarsESO}
\alias{HVAC_Diagram}
\alias{energyplus}
\title{Run EnergyPlus and its various processors}
\usage{
EPMacro(
  model,
  output_dir = NULL,
  output_prefix = NULL,
  wait = TRUE,
  echo = TRUE,
  eplus = NULL
)

ExpandObjects(
  model,
  output_dir = NULL,
  output_prefix = NULL,
  wait = TRUE,
  echo = TRUE,
  eplus = NULL,
  idd = NULL
)

Basement(
  model,
  weather,
  output_dir = NULL,
  output_prefix = NULL,
  wait = TRUE,
  echo = TRUE,
  eplus = NULL,
  idd = NULL
)

Slab(
  model,
  weather,
  output_dir = NULL,
  output_prefix = NULL,
  wait = TRUE,
  echo = TRUE,
  eplus = NULL,
  idd = NULL
)

EnergyPlus(
  model,
  weather,
  output_dir = NULL,
  output_prefix = NULL,
  output_suffix = c("C", "L", "D"),
  wait = TRUE,
  echo = TRUE,
  annual = FALSE,
  design_day = FALSE,
  idd = NULL,
  eplus = NULL
)

convertESOMTR(
  eso,
  output_dir = NULL,
  output_prefix = NULL,
  rules = NULL,
  wait = TRUE,
  echo = TRUE,
  eplus = NULL
)

ReadVarsESO(
  eso,
  output_dir = NULL,
  output_prefix = NULL,
  output_suffix = c("C", "L", "D"),
  max_col = NULL,
  wait = TRUE,
  echo = TRUE,
  eplus = NULL
)

HVAC_Diagram(
  bnd,
  output_dir = NULL,
  output_prefix = NULL,
  wait = TRUE,
  echo = TRUE,
  eplus = NULL
)

energyplus(
  model,
  weather,
  output_dir = NULL,
  output_prefix = NULL,
  output_suffix = c("C", "L", "D"),
  epmacro = TRUE,
  expand_obj = TRUE,
  annual = FALSE,
  design_day = FALSE,
  eso_to_ip = FALSE,
  readvars = TRUE,
  echo = TRUE,
  wait = TRUE,
  idd = NULL,
  eplus = NULL,
  resources = NULL
)
}
\arguments{
\item{model}{[\code{character(1)}]\cr
A path of an EnergyPlus IDF or IMF file.}

\item{output_dir}{[\code{character(1)} or \code{NULL}]\cr
Output directory of EnergyPlus simulation outputs. If \code{NULL}, the directory
where the input \code{model} locates is used. Default: \code{NULL}.}

\item{output_prefix}{[\code{character(1)} or \code{NULL}]\cr
Prefix for EnergyPlus output file names. If \code{NULL}, the input \code{model} file
name is used.  Default: \code{NULL}.}

\item{wait}{[\code{logical(1)}]\cr
If \code{FALSE}, simulation is run in the background and a \link[processx:process]{processx::process}
object is returned. Extra steps are needed to collect the results after the
process completes.}

\item{echo}{[\code{logical(1)}]\cr
Wheter to show standard output and error from EnergyPlus and its pre- and
post- processors. Default: \code{TRUE}.}

\item{eplus}{[\code{character(1)} or \code{NULL}]\cr
An EnergyPlus version or a path of EnergyPlus installation directory. If
\code{NULL}, the version of EnergyPlus to use is determined by the version of
input \code{model}. Default: \code{NULL}.}

\item{idd}{[\code{character(1)} or \code{NULL}]\cr
The full path of EnergyPlus IDD (Input Data Dictionary). If \code{NULL},
\code{Energy+.idd} file in EnergyPlus installation directory is used. Default:
\code{NULL}.}

\item{weather}{[\code{character(1)} or \code{NULL}]\cr
A path of an EnergyPlus weather (EPW) file. If \code{NULL}, design-day-only
simulation is triggered, regardless of the \code{design_day} value.}

\item{output_suffix}{[\code{character(1)}]\cr
Suffix style for EnergyPlus output file names. Should be one of the
followings:
\itemize{
\item \code{C}: \strong{Capital}, e.g. \code{eplusTable.csv}. This is the default.
\item \code{L}: \strong{Legacy}, e.g. \code{eplustbl.csv}.
\item \code{D}: \strong{Dash}, e.g. \code{eplus-table.csv}.
}}

\item{annual}{[\code{logical(1)}]\cr
If \code{TRUE}, annual simulation is forced. Currently, only support EnergyPlus >=
v8.3. Note that \code{annual} and \code{design_day} cannot both be \code{TRUE}. Default:
\code{FALSE}.}

\item{design_day}{[\code{logical(1)}]\cr
If \code{TRUE}, design-day-only simulation is forced. Currently, only support
EnergyPlus >= v8.3. Note that \code{annual} and \code{design_day} cannot both be
\code{TRUE}. Default: \code{FALSE}.}

\item{eso}{[\code{character(1)}]\cr
A path of an EnergyPlus standard output (\code{.eso}) or EnergyPlus meter output
(\code{.mtr}) file.}

\item{bnd}{[\code{character(1)}]\cr
A path of an EnergyPlus branch node details (\code{.bnd}) file.}

\item{epmacro}{[\code{logical(1)}]\cr
If \code{TRUE}, EPMacro processor is called perior to simulation. Only applicable
if input file is an \code{IMF} file. Default: \code{TRUE}.}

\item{expand_obj}{[\code{logical(1)}]\cr
If \code{TRUE}, ExpandObjects processor is called perior to simulation. Should be
\code{TRUE} if calling Basement or Slab preprocessors is desired. Default: \code{TRUE}.}

\item{eso_to_ip}{[\code{logical(1)}]\cr
If \code{TRUE}, convertESOMTR post-processor is called after simulation to convert
the units of data in \code{eso} file from SI units to IP units. Default: \code{FALSE}.}

\item{readvars}{[\code{logical(1)}]\cr
If \code{TRUE}, ReadVarsESO post-processor is called after to simulation. Default:
\code{TRUE}.}

\item{resources}{[\code{character()} or \code{NULL}]\cr
Any external file dependencies that EnergyPlus will use for simulation. If
not \code{NULL}, files will be copied to the output directory. Default: \code{NULL}.}
}
\value{
Functions except for \code{energyplus()} return a list of two elements:
\itemize{
\item \code{file}: a named list of full paths of output files
\item \code{run}: a named list of outputs from the process.
}

\code{energyplus()} returns a list of 7 elements:
\itemize{
\item \code{ver}: EnergyPlus \link[=numeric_version]{version} used
\item \code{energyplus}: EnergyPlus installation directory
\item \code{start_time}: a \code{\link[=POSIXct]{POSIXct()}} giving the local time when the simulation
starts
\item \code{end_time}: a \code{\link[=POSIXct]{POSIXct()}} giving the local time when the simulation ends
\item \code{output_dir}: full path of output directory of simulation outputs
\item \code{file}: a named list of relative paths of output files under \code{output_dir}
\item \code{run}: a \link[data.table:data.table]{data.table} of each outputs from the
all called processes
}
}
\description{
Run EnergyPlus and its various processors
}
\details{
\code{EPMacro()} calls the EnergyPlus EPMacro processor.

\code{ExpandObjects()} calls the EnergyPlus ExpandObjects processor.

\code{Basement()} calls the EnergyPlus Basement preprocessor.

\code{Slab()} calls the EnergyPlus Slab preprocessor.

\code{EnergyPlus()} calls EnergyPlus itself.

\code{convertESOMTR()} calls EnergyPlus convertESOMTR post-processor.

\code{ReadVarsESO()} calls EnergyPlus ReadVarsESO post-processor.

\code{HVAC_Diagram()} calls EnergyPlus HVAC-Diagram post-processor.

\code{energyplus()} is the one which correctly chains all the steps that call
those pre- and post- processors to form a complete EnergyPlus simulation.
}
\note{
\code{energyplus()} can only run in waiting mode.
}
\keyword{internal}
