% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{get_idf_table}
\alias{get_idf_table}
\title{Extract value data in a data.table}
\usage{
get_idf_table(
  idd_env,
  idf_env,
  class = NULL,
  object = NULL,
  string_value = TRUE,
  unit = FALSE,
  wide = FALSE,
  align = FALSE,
  all = FALSE,
  group_ext = c("none", "group", "index"),
  force = FALSE,
  init = FALSE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{class}{An integer vector of valid class indexes or a character vector
of valid class names. Default: \code{NULL}.}

\item{object}{An integer vector of valid object IDs or a character vector
of valid object names. Default: \code{NULL}.}

\item{string_value}{If \code{TRUE}, all field values are returned as
character. If \code{FALSE}, \code{value} column in returned
\link[data.table:data.table]{data.table} is a list column with
each value stored as corresponding type. Note that if the
value of numeric field is set to \code{"Autosize"} or
\code{"Autocalculate"}, it is left as it is, leaving the returned
type being a string instead of a number. Default: \code{TRUE}.}

\item{unit}{Only applicable when \code{string_value} is \code{FALSE}. If
\code{TRUE}, values of numeric fields are assigned with units using
\code{\link[units:set_units]{units::set_units()}} if applicable. Default: \code{FALSE}.}

\item{wide}{Only applicable if target objects belong to a same class.
If \code{TRUE}, a wide table will be returned, i.e. first three
columns are always \code{id}, \code{name} and \code{class}, and then every
field in a separate column. Note that this requires all
objects specified must from the same class.
Default: \code{FALSE}.}

\item{align}{If \code{TRUE}, all objects in the same class will have the
same field number. The number of fields is the same as the
object that have the most fields among objects specified.
Default: \code{FALSE}.}

\item{all}{If \code{TRUE}, all available fields defined in IDD for the
class that objects belong to will be returned. Default:
\code{FALSE}.}

\item{group_ext}{Should be one of \code{"none"}, \code{"group"} or \code{"index"}.
If not \code{"none"}, \code{value} column in returned
\code{\link[data.table:data.table]{data.table::data.table()}} will be converted into a list.
If \code{"group"}, values from extensible fields will be grouped by the
extensible group they belong to. For example, coordinate
values of each vertex in class \code{BuildingSurface:Detailed} will
be put into a list. If \code{"index"}, values from extensible fields
will be grouped by the extensible field indice they belong to.
For example, coordinate values of all x coordinates will be
put into a list. If \code{"none"}, nothing special will be done.
Default: \code{"none"}.}

\item{force}{If \code{TRUE}, \code{wide} can be \code{TRUE} even though there are
multiple classes in input. This can result in a data.table
with lots of columns. But may be useful when you know that
target classes have the exact same fields, e.g.
\code{Ceiling:Adiabatic} and \code{Floor:Adiabatic}. Default: \code{FALSE}.}

\item{init}{If \code{TRUE}, a table for new object input will be returned
with all values filled with defaults. In this case, \code{object}
input will be ignored. The \code{id} column will be filled with
possible new object IDs. Default: \code{FALSE}.}
}
\value{
A \link[data.table:data.table]{data.table} with 6 columns (if
\code{wide} is \code{FALSE}) or at least 5 columns (if \code{wide} is \code{TRUE}).

When \code{wide} is \code{FALSE}, the 5 columns are:
\itemize{
\item \code{id}: Integer type. Object IDs.
\item \code{name}: Character type. Object names.
\item \code{class}: Character type. Current class name.
\item \code{index}: Integer type. Field indexes.
\item \code{field}: Character type. Field names.
\item \code{value}: Character type if \code{string_value} is \code{TRUE} or list type if
\code{string_value} is \code{FALSE} or \code{group_ext} is not \code{"none"}. Field values.
}
}
\description{
Extract value data in a data.table
}
\keyword{internal}
