% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idfobj.R
\name{format.IdfObject}
\alias{format.IdfObject}
\title{Format an IdfObject}
\usage{
\method{format}{IdfObject}(x, comment = TRUE, leading = 4L, sep_at = 29L, all = FALSE, ...)
}
\arguments{
\item{x}{An \link{IdfObject} object.}

\item{comment}{If \code{FALSE}, all comments will not be included. Default: \code{TRUE}.}

\item{leading}{Leading spaces added to each field. Default: \code{4L}.}

\item{sep_at}{The character width to separate value string and field string.
Default: \code{29L} which is the same as IDF Editor.}

\item{all}{If \code{TRUE}, values of all possible fields in current class the
\link{IdfObject} belongs to are returned. Default: \code{FALSE}}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A character vector.
}
\description{
Format an \link{IddObject} into a character vector in the same way as in IDF Editor.
}
\examples{
\dontrun{
idf <- read_idf(system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr"),
    idd = use_idd(8.8, download = "auto"))

# get the IdfObject of material named "C5 - 4 IN HW CONCRETE"
mat <- idf$Material[["C5 - 4 IN HW CONCRETE"]]

cat(format(mat, leading = 0, sep_at = 10))
}

}
