% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsir.R
\name{tsirSim2}
\alias{tsirSim2}
\title{Function to simulate the seasonally-forced TSIR}
\usage{
tsirSim2(beta, alpha, B, N, inits = list(Snull = 0, Inull = 0), type = "det")
}
\arguments{
\item{beta}{the seasonal transmission coefficients}

\item{alpha}{the exponent on I}

\item{B}{a vector of Births (the length of which determines the length of the simulation)}

\item{N}{the population size}

\item{inits}{a list containing initial S and I}

\item{type}{an argument "det" or "stoc" that determines whether a deterministic or stochastic simulation is done}
}
\value{
A list with time series of simulated infected and susceptible hosts
}
\description{
Function to simulate the stochastic TSIR assuming stochasticity in transmission and a Poisson birth-death process
}
\examples{
\donttest{"See chapter 8 in book"}
}
