% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_vars.R
\name{global_vars}
\alias{global_vars}
\alias{epiflows.vars}
\title{Epiflow Global Variables}
\usage{
global_vars(..., set = FALSE, reset = FALSE)
}
\arguments{
\item{...}{quoted varaibles to add to the default variables}

\item{set}{when \code{TRUE}, the variables provided in \code{...} will be added to the
global variables. Defaults to \code{FALSE}}

\item{reset}{when \code{TRUE}, the global variables are reset to the default
variables listed above. Defaults to \code{FALSE}}
}
\description{
The metadata in \strong{locations} such as population size, duration of stay in a
given location, date of first and last cases, etc. can be useful in estimating
the risk of spread, but not everyone will code their data with identical column
names. To facilitate their use in the function \code{estimate_risk_spread()}, the
epiflows object stores a dictionary of variables in a place called \code{$vars}.
We can tell epiflows what variables are important when we create the object.
}
\details{
The default varaibles are:
\itemize{
\item \code{coordinates}: two columns specifying the lon and lat coordinates
\item \code{pop_size}: population size of each location
\item \code{duration_stay}: the average duration of stay for each location
\item \code{first_date}: the date of first recorded case
\item \code{last_date}: the date of the last recorded case
\item \code{num_cases}: the number of cases between the first and last date
}
}
\examples{

# see the default varaibles
global_vars()

# Equivalent
getOption("epiflows.vars")

# create an object, specifying these variables
data("YF_locations")
data("YF_flows")
ef <- make_epiflows(flows         = YF_flows, 
                    locations     = YF_locations, 
                    pop_size      = "location_population",
                    duration_stay = "length_of_stay",
                    num_cases     = "num_cases_time_window",
                    first_date    = "first_date_cases",
                    last_date     = "last_date_cases"
                   )
ef

\donttest{
# You will receive an error if a variable is specified incorrectly
YF_locations$random_variable <- runif(nrow(YF_locations))
try({
  ef <- make_epiflows(flows         = YF_flows, 
                      locations     = YF_locations, 
                      Pop_size      = "location_population",
                      duration_stay = "length_of_stay",
                      num_cases     = "num_cases_time_window",
                      first_date    = "first_date_cases",
                      last_date     = "last_date_cases",
                      random        = "random_variable"
                     )
   })
}

# If you create a new method and need other varaibles, or just want a shorter
# representation, they can be added to your options:

global_vars("random", set = TRUE)

YF_locations$random_variable <- runif(nrow(YF_locations))
ef <- make_epiflows(flows         = YF_flows, 
                    locations     = YF_locations, 
                    pop_size      = "location_population",
                    duration_stay = "length_of_stay",
                    num_cases     = "num_cases_time_window",
                    first_date    = "first_date_cases",
                    last_date     = "last_date_cases",
                    random        = "random_variable"
                   )

# You can also reset the variables
global_vars(reset = TRUE)
}
\seealso{
\code{\link[=make_epiflows]{make_epiflows()}}, \code{\link[=get_locations]{get_locations()}}, \code{\link[=get_vars]{get_vars()}}, \code{\link[=set_vars]{set_vars()}}, \code{\link[=get_coordinates]{get_coordinates()}}
}
