% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_admin_names.R
\name{get_admin_names}
\alias{get_admin_names}
\title{Retrieve Administrative Names from GeoNames}
\usage{
get_admin_names(country_name_or_code, silent_mode = TRUE)
}
\arguments{
\item{country_name_or_code}{Character or numeric. The name or code of the
country for which administrative names are to be retrieved. This can be in
various formats such as country name, ISO codes, UN codes, etc., see
`countrycode::codelist()` for the full list of codes and naming conventions
used.}

\item{silent_mode}{A logical indicating whether to suppress messages.
Default is TRUE.}
}
\value{
A list containing administrative region names and details for
        different administrative levels (e.g., ADM1, ADM2, etc.). Each
        element of the list corresponds to a different administrative level
        and contains a data frame with columns such as country_code,  ascii
        name, alternate names, latitude, longitude, and date last updated.
}
\description{
This function grabs administrative region names (such as districts,
provinces, etc.) for a given country from the `GeoNames` website. It accepts
both country names and various country coding schemes.
}
\examples{
\donttest{
# example using different naming/code conventions
three_digit <- get_admin_names("TGO")   # using 3 digit iso codes
two_digit <- get_admin_names("TG")      # using 2 digit iso codes
un_code <- get_admin_names(768)         # using UN codes
full_name <-  get_admin_names("Togo")   # using full names

str(full_name$adm2)
}

}
\seealso{
`Geonames` website for the source of admin
names data
}
