% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uuid.R
\name{envvar_get_uuid}
\alias{envvar_get_uuid}
\title{Environment variables for UUIDs}
\usage{
envvar_get_uuid(x, default = NULL, validate = NULL, warn_default = TRUE)
}
\arguments{
\item{x}{String containing an environment variable name}

\item{default}{Optional default value if the environment variable is not set}

\item{validate}{Optional function that checks a value for validity}

\item{warn_default}{Show a warning if the default value is used
(default: \code{TRUE})}
}
\value{
An object of the class \code{"UUID"} representing a vector of UUIDs.
}
\description{
\code{envvar_get_uuid()} gets a UUID from an environment variable
}
\examples{

# Get a file path and make sure it exists
envvar_set("DEMO_GUID" = "d647f20f-c44c-4914-8255-9eca97150d4c")
envvar_get_uuid("DEMO_GUID")
}
