% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{is_memory_address}
\alias{is_memory_address}
\title{Check whether a string is a memory address}
\usage{
is_memory_address(x)
}
\arguments{
\item{x}{object to check.}
}
\value{
boolean indicating whether the given object represents a valid memory address.
}
\description{
Check whether an object represents a valid memory address. If the object does not exist or is not of the
correct type FALSE is returned, no error is raised.
}
\details{
Valid memory addresses depend on the architecture. For instance for:
- for Windows 32-bit systems, an 8-bit representation (since 2^32 = 16^8)
- for Windows 64-bit systems, a 16-bit representation (since 2^64 = 16^16)
- for Linux Debian 64-bit systems, a 12-bit representation seems to be the case...
(ref: Ubuntu 18.04 LTS on Windows)

Example of valid memory addresses for Windows 64-bit systems:
"<(16-digit-code)>" (e.g. "<000000000974E880>")
"<0x(16-digit-code)>" (e.g. "<0x000000000974E880>")
"<environment: 0x(16-digit-code)>" (e.g. "<environment: 0x000000000974E880>")
}
\keyword{internal}

