% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_offs.R
\name{n_offs}
\alias{n_offs}
\title{Return Scorelines that only occurred n times in history}
\usage{
n_offs(df = NULL, N = NULL, Tier = NULL)
}
\arguments{
\item{df}{The results dataframe}

\item{N}{The Number of instances}

\item{Tier}{Tier}
}
\value{
a dataframe with summary of results.
}
\description{
note don't try this with 0 - won't return infinite possible scorelines
If you pick crazy numbers for the number of times e.g. 34223,
you'll get an error message this function is meant for small
numbers of occurrences
}
\examples{
n_offs(england, 1) #return results that have occurred only once across all four tiers
n_offs(england, 2) #return results that have occurred only twice across all four tiers
n_offs(england, 3) #return results that have occurred 3 times across all four tiers

n_offs(england, 1, 1) #return which results have occurred only once in the top tier
n_offs(england, 1, 4) #return which results have occurred only once in the 4th tier
n_offs(england, 2, 2) #return which results have occurred twice in the 2nd tier
n_offs(england, 5, 3) #return which results have occurred five times in the 3rd tier

}

