% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMR.R
\name{SMR}
\alias{SMR}
\alias{SMR.table}
\alias{forest.SMR}
\title{Standardized Mortality Ratio (SMR)}
\usage{
SMR(obs.var, pred.var, digits = 5, ci.method = c("Hosmer", "Byar"),
  ci.level = 0.95)

SMR.table(data, group.var, obs.var, pred.var, digits = 5, use.label = FALSE,
  var.labels = attr(data, "var.labels")[match(group.var, names(data))],
  ci.method = c("Hosmer", "Byar"), ci.level = 0.95, reorder = c("no",
  "SMR", "lower.Cl", "upper.Cl"), decreasing = FALSE)

forest.SMR(x, mar1 = c(5.1, 1, 4.1, 1), mar.SMR = c(5.1, 7, 4.1, 1),
  overall.arg = list(x = 0.01, font = 2, las = 1, labels = var.labels[1], xpd
  = NA, adj = 0), NOE.overall.args = list(x = c(N.values.arg$x,
  O.values.arg$x, E.values.arg$x), font = 2, las = 1, xpd = NA),
  var.labels.arg = list(x = 0.01, font = 2, las = 1, cex = 1, xpd = NA, adj =
  0), cat.labels.arg = list(x = 0.1, font = 3, las = 1, cex = 0.95, col =
  gray(0.4), xpd = NA, adj = 0), N.values.arg = list(x = 0.5, col = gray(0.4),
  xpd = NA), O.values.arg = list(x = 0.675, col = gray(0.4), xpd = NA),
  E.values.arg = list(x = 0.85, col = gray(0.4), xpd = NA),
  NOE.head.arg = list(font = 2, labels = c("N", "O", "E"), xpd = NA),
  Overall.seg.arg = list(col = "navyblue", xpd = NA, lwd = 2),
  Overall.p.arg = list(pch = 23, cex = 2, col = "black", bg = gray(0.4), xpd =
  NA), Overall.est.arg = list(x = smr.xlim[1] - 0.06, las = 1, font = 2, xpd =
  NA, adj = 1), cat.seg.arg = list(col = "navyblue", xpd = NA, lwd = 2),
  cat.p.arg = list(pch = 22, cex = 1, col = "black", bg = gray(0.4), xpd =
  NA), cat.est.arg = list(x = smr.xlim[1] - 0.06, las = 1, col = gray(0.4),
  xpd = NA, adj = 1), SMR.head.arg = list(smr.xlim[1] - 0.06, font = 2, labels
  = "SMR [95\% CIs]", xpd = NA, adj = 1),
  smr.xlab = "Standardized Mortality Ratio", smr.xlim = "auto",
  grid = TRUE, digits = 3)
}
\arguments{
\item{obs.var}{Observed death. Accepted values are 0 (absence) or 1 (presence) in a vector. For \code{SMR.table} is must be a character indicating the name of the variable in data.}

\item{pred.var}{Death individual predictions (ranging from 0 to 1) in a vector. For \code{SMR.table} is must be a character indicating the name of the variable in data.}

\item{digits}{Number of digits for rounding the output.}

\item{ci.method}{Method to estimate the confidence interval. "Hosmer" (default) or "Byar" are acceptable values.}

\item{ci.level}{Level of the confidence interval. Default is 0.95.}

\item{data}{For \code{SMR.table}, a dataset where pred.var, obs.var and group.var are in.}

\item{group.var}{For \code{SMR.table}, this is a character vector indicating the name(s) of the variable(s) in data will form the groups in where SMR will be calculated. Must be factor variables.}

\item{use.label}{Logical. Default is FALSE. For \code{SMR.table} this option will replace the variables names by its labels in var.labels argument.}

\item{var.labels}{A character vector with variables labels. The default is to replace the variable name by the label stored at attr(data, "var.labels"). But one may specify labels directly.}

\item{reorder}{Default is "no". Possible values are: "no", "SMR","lower.Cl", and "upper.Cl". Will make the \code{SMR.table} to be ordered within each varibale by its original order, or by SMR order, or by lower.Cl order, or by upper.Cl.}

\item{decreasing}{Logical. When 'reorderd' is TRUE, should the order be decreasing or incresing? See \code{\link[base]{order}}}

\item{x}{For the \code{forest.SMR} this is the output of \code{SMR.table}.}

\item{mar1, mar.SMR}{Values to set the margins (mar parameter) of left and right windows. See \code{\link[graphics]{par}}}

\item{overall.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the overall label. Internally  and 'y' coordinate is replaced.}

\item{NOE.overall.args}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the overall N (number of observations), O (observed deaths) and E (expected deaths). Internally 'labels' and 'y' arguments are replaced.}

\item{var.labels.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the variables labels. Internally  and 'y' coordinate is replaced.}

\item{cat.labels.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the categories labels. Internally  and 'y' coordinate is replaced.}

\item{N.values.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the values of N (number of observations) of each subgroup. Internally the arguments 'label' and 'y' coordinate are replaced.}

\item{O.values.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the values of Observed deaths of each subgroup. Internally the arguments 'label'  and 'y' coordinate are replaced.}

\item{E.values.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the values of Expected deaths of each subgroup. Internally the arguments 'label'  and 'y' coordinate are replaced.}

\item{NOE.head.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the labels of the columns N, E and O on the top of the graph. Internally the 'x' and 'y' coordinate are replaced. The x coordinates are taken from the x in N.values.arg, O.values.arg and E.values.arg.}

\item{Overall.seg.arg}{A list of arguments passed to \code{\link[graphics]{segments}} for ploting the lines corresponding to overall SMR confidence intervals. Internally 'x' and 'y' coordinates are replaced.}

\item{Overall.p.arg}{A list of arguments passed to \code{\link[graphics]{points}} for ploting the points corresponding to overall SMR. Internally 'x' and 'y' coordinates are replaced.}

\item{Overall.est.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the overall SMR beside the graph. Internally 'y' coordinate and 'label' argument are replaced.}

\item{cat.seg.arg}{A list of arguments passed to \code{\link[graphics]{segments}} for ploting the lines corresponding to SMR confidence intervals for all groups. Internally 'x' and 'y' coordinates are replaced.}

\item{cat.p.arg}{A list of arguments passed to \code{\link[graphics]{points}} for ploting the points corresponding to all categoreis SMR. Internally 'x' and 'y' coordinates are replaced.}

\item{cat.est.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the categories SMR beside the graph. Internally 'y' coordinate and 'label' arguments are replaced.}

\item{SMR.head.arg}{A list of arguments passed to \code{\link[graphics]{text}} for ploting the label of the SMR column on the top of the graph. Internally the 'and 'y' coordinate is replaced.}

\item{smr.xlab}{Label of the x axis. Default is "Standardized Mortality Ratio".}

\item{smr.xlim}{Limits of x axis of the \code{forest.SMR} plot. Default is "auto", which internally will pick the highest values of all upper.Cl and the lowest lower.Cl. Besides "auto", only a vector of 2 numbers are valid, and will be passed to \code{\link[graphics]{plot.default}}.}

\item{grid}{Logical. If TRUE (default), it will draw a grid with the \code{\link[graphics]{grid}} default arguments.}
}
\value{
If SMR, then:
\itemize{
\item \code{N} Number of subjects analyzed.
\item\code{O} Observed number of deaths.
\item \code{E} Expected number of deaths.
\item \code{SMR} Standardized mortality ratio.
\item \code{lower.Cl} lower confidence limit.
\item \code{upper.Cl} upper confidence limit.
}

If SMR.table, then a data.frame with the same information as above, and the
 additional information: "Variables" (variables names), "Levels" (variables levels).

If forest.SMR, then a plot is returned.
}
\description{
Calculates the standardized mortality ratio and its confidence interval. SMR, for a group, is defined as the ratio of the observed deaths in this group and the sum of the predicted individual probabilities of death by any model (expected deaths).

\code{SMR.table} estimate at once the overall SMR and the SMR across several groups, e.g. ICU units or clinical characteristics. The \code{SMR.table} can be ordered by the SMR estimate or its confidence intervals, facilitating the comparinson of the units ranks.

\code{forest.SMR} shows the \code{SMR.table} output as a forest plot. The plot opens two windows and plot at the left side the values from the \code{SMR.table} and at the right side the points and lines graphically representing each SMR and its confidence interval.
}
\examples{
# Loading a example data
data(icu)

# Setting variable labels to data
attr(icu, "var.labels")[match(c("Unit", "IsMechanicalVentilation1h",
          "AdmissionTypeName_pri","Vasopressors_D1"), names(icu))] <-
  c("ICU unit","Mechanichal ventilation","Admission type","Vasopressors at admission")

# Some editing
icu$Saps3DeathProbabilityStandardEquation <- icu$Saps3DeathProbabilityStandardEquation /100
icu$IsMechanicalVentilation1h <- as.factor(ifelse(icu$IsMechanicalVentilation1h == 1, "Yes", "No"))
icu$AdmissionTypeName_pri <- as.factor(icu$AdmissionTypeName_pri)
levels(icu$AdmissionTypeName_pri) <- c("Clinical","Elective surgery", "Urgent surgery")
icu$Vasopressors_D1 <- as.factor(ifelse(icu$Vasopressors_D1 == 1, "Yes", "No"))

# The overall SMR for the whole sample
SMR(icu$UnitDischargeName, icu$Saps3DeathProbabilityStandardEquation)

# The overall SMR and for some subgroups
x <- SMR.table(data = icu, obs.var = "UnitDischargeName",
               pred.var = "Saps3DeathProbabilityStandardEquation",
               group.var = c( "IsMechanicalVentilation1h",
               "AdmissionTypeName_pri","Vasopressors_D1"),
               reorder = "no",
               decreasing = TRUE,
               use.label = TRUE)
x

# A forest plot for all groups SMR (resize the window may be required)
forest.SMR(x, digits = 2)

# The same thing but reordering the categories
x <- SMR.table(data = icu, obs.var = "UnitDischargeName",
               pred.var = "Saps3DeathProbabilityStandardEquation",
               group.var = c( "IsMechanicalVentilation1h",
               "AdmissionTypeName_pri", "Vasopressors_D1"),
               reorder = "SMR",
               decreasing = TRUE,
               use.label = TRUE)
forest.SMR(x, digits = 2)

# The overall SMR and for all Units
x <- SMR.table(data = icu, obs.var = "UnitDischargeName",
               pred.var = "Saps3DeathProbabilityStandardEquation",
               group.var = "Unit",
               reorder = "no",
               decreasing = TRUE,
               use.label = TRUE)
x

# A forest plot for all Units
forest.SMR(x, digits = 2)

# The same thing but reordering the categories
x <- SMR.table(data = icu, obs.var = "UnitDischargeName",
               pred.var = "Saps3DeathProbabilityStandardEquation",
               group.var = "Unit",
               reorder = "SMR",
               decreasing = TRUE,
               use.label = TRUE)
forest.SMR(x, digits = 2)

rm(x, icu)
}
\author{
Lunna Borges and Pedro Brasil
}
\references{
David W. Hosmer and Stanley Lemeshow. Confidence intervals estimates of an index of quality performance basend on logistic regression models. Statistics in Medicine , vol. 14, 2161-2172 (1995)
}
\seealso{
\code{\link{SRU}}, \code{\link{reclass}}, \code{\link{funnel}}
}

