% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.r
\name{log_message}
\alias{log_message}
\title{Print a timestamped and indented log message}
\usage{
log_message(indent = 1, ..., time = TRUE, domain = "R-emil",
  appendLF = TRUE)
}
\arguments{
\item{indent}{Indentation level. Messages with \code{indent=0} are
suppressed.}

\item{...}{Sent to \code{\link{sprintf}}.}

\item{time}{Whether or not to print timestamp.}

\item{domain}{See \code{\link{message}}.}

\item{appendLF}{Whether to finish the message with a linebreak or not.}
}
\description{
To suppress messages below a given indentation level set the global
\code{\link{option}} setting \code{emil_max_indent}, as in the example below.
}
\examples{
equipment <- c("flashlight", "snacks", "pick")
{
    log_message(1, "Begin descent")
    log_message(2, "Oh no, forgot the \%s!", sample(equipment, 1))
    log_message(2, "Hello? Can you throw it down to me?", time=FALSE)
    log_message(1, "Aw shucks, I'm coming back up.")
}

for(verbose in c(TRUE, FALSE)){
    cat("It's", verbose, "\\n")
    for(i in 0:3)
        log_message(indent(verbose, i), "Down")
}

options(emil_max_indent = 2)
for(i in 1:3)
    log_message(i, "Down")
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
