% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.Nests.R
\name{hist.Nests}
\alias{hist.Nests}
\title{Show the histogram of temperatures with set of nests}
\usage{
\method{hist}{Nests}(x, series = "all", ...)
}
\arguments{
\item{x}{Data formated using formatdata.}

\item{series}{Series to be used, logical (TRUE ou FALSE), numbers or names. If "all", all series are used.}

\item{...}{Parameters used by hist function}
}
\value{
A list with an histogram object with information on histogram or 
NULL if no series was selected and the complete set of temperatures used.
}
\description{
Show the histogram of temperatures with set of nests
hist(data)
}
\details{
hist.Nests shows the histogram of temperatures with set of nests
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
h <- hist(formated, series="all")
}
}
\author{
Marc Girondot \email{marc.girondot@universite-paris-saclay.fr}
}
