% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateTest.R
\name{GenerateTest}
\alias{GenerateTest}
\title{Generate a data.frame that can be used as test value for searchR()}
\usage{

  GenerateTest(series = stop("A result object or names of series must be provided"),
  size = NULL, previous = NULL)
}
\arguments{
\item{series}{Name of series or object from searchR()}

\item{size}{Size or mass at hatching. Will be recycled if necessary}

\item{previous}{Previous formated test data}
}
\value{
A data.frame with size or mass at hatching for each nest
}
\description{
Generate a data.frame that can be used as test value for searchR()
}
\details{
GenerateTest Generate a data.frame that can be used as test value for searchR()
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
testsize1 <- GenerateTest(resultNest_4p)
testsize2 <- GenerateTest(series=resultNest_4p,  
	size=c(Mean=39.3, SD=1.92))
}
}
\author{
Marc Girondot
}

