% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormatNests.R
\name{FormatNests}
\alias{FormatNests}
\title{Create a dataset of class Nests to be used with searchR}
\usage{
FormatNests(data = stop("A dataset must be provided !"), previous = NULL,
  simplify = TRUE, weight = NULL)
}
\arguments{
\item{data}{Data to be newly formated}

\item{previous}{Data already formated}

\item{simplify}{If TRUE, simply the time series by removing identical time series of temperatures}

\item{weight}{Named vector with weight for likelihhod}
}
\value{
A list with all the nests formated to be used with searchR.
}
\description{
Will create a dataset of class Nests to be used with searchR\cr
FormatNests(nest, previous=x) with x being a previously formated data.\cr
The raw data must be organized being:\cr
First column is the time in minutes since the beginning of incubation\cr
Each column next is the trace of temperatures, one column for each nest.\cr
For example, for two nests:\cr
Time   Nest1    Nest2\cr
0       29.8     27.6\cr
90      30.2     28.8\cr
120     30.4     30.7\cr
180     31.2     32.6\cr
...\cr
65800   30.8     32.6\cr
65890            30.2\cr
65950            30.4\cr
\cr
The Nest1 ends incubation at 65800 minutes whereas Nest2 ends incubation at 65950 (last row\cr
with temperature for each).\cr
The parameter Weight is a vector: weight=c(Nest1=1, Nest2=1.2)\cr
It can be used to format database already formated with old format; in this case, just use data=xxx with xxx being the old format database.\cr
}
\details{
FormatNests creates a dataset of class "Nests" to be used with searchR
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest, previous=NULL)
formated <- FormatNests(nest)
}
}
\author{
Marc Girondot
}

