% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STRN.R
\name{STRN}
\alias{STRN}
\title{Estimate the parameters that best describe the sexualisation thermal reaction norm within the TSP}
\usage{
STRN(Initial_STRN = NULL,
  EmbryoGrowthTRN = stop("Embryo Growth Thermal Reaction Norm must be provided"),
  tsd = stop("A result from the function tsd() must be provided"),
  Sexed = NULL, Males = NULL, Females = NULL,
  Temperatures = "TSP.MassWeighted.STRNWeighted.temperature.mean", ...)
}
\arguments{
\item{Initial_STRN}{Values for initial model of Sexualisation Thermal Reaction Norm}

\item{EmbryoGrowthTRN}{The Embryo growth Thermal Reaction Normal obtained with searchR()}

\item{tsd}{The model used to predict sex ratio, obtained from tsd()}

\item{Sexed}{The number of sexed embryos}

\item{Males}{The number of males embryos}

\item{Females}{The number of females embryos}

\item{Temperatures}{The temperature from out of info.nests to be used}

\item{...}{Parameters used for optim()}
}
\value{
The list with object return by optim()
}
\description{
Estimate the parameters that best describe the sexualisation thermal reaction norm within the TSP.\cr
The Temperatures parameter is a character string which can be:\cr
\itemize{
  \item \code{TimeWeighted.temperature.mean}
  \item \code{TSP.TimeWeighted.temperature.mean}
  \item \code{TSP.MassWeighted.temperature.mean}
  \item \code{TSP.STRNWeighted.temperature.mean}
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.mean}
  \item \code{MiddleThird.TimeWeighted.temperature.mean}
  }
}
\details{
STRN estimates the parameters that best describe the sexualisation thermal reaction norm within the TSP
}
\author{
Marc Girondot
}

