% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}
\alias{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}
\title{Get average link operator difference matrix based on specific synergy prediction}
\usage{

  get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction(model.predictions,
  models.link.operator, predicted.synergies)
}
\arguments{
\item{model.predictions}{a \code{data.frame} object with rows the models and
columns the drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}

\item{models.link.operator}{matrix (nxm) with n models and m nodes. The row
names of the matrix specify the models' names (same order as in the
\code{models.mcc} parameter) whereas the column names specify the name of the
network nodes (gene, proteins, etc.). Possible values for each \emph{model-node
element} are either \emph{0} (\strong{AND NOT} link operator), \emph{1}
(\strong{OR NOT} link operator) or \emph{0.5} if the node is not targeted by
both activating and inhibiting regulators (no link operator).}

\item{predicted.synergies}{a character vector of the synergies (drug
combination names) that were predicted by \strong{at least one} of the models
in the dataset. It must be a subset of the column names (the drug combinations)
of the \code{model.predictions} object.}
}
\value{
a matrix whose rows are \strong{vectors of average node link operator
differences} between two groups of models where the classification for each
individual row was based on the prediction or not of a specific synergistic
drug combination.
The row names are the predicted synergies, one per row, while the columns
represent the network's node names. Values are in the [-1,1] interval.
the classification was based on the models' MCC values.
}
\description{
This function uses the \code{\link{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}}
function with the parameter \code{models.link.operator} as input in the place of
\code{models.stable.state}, since the two matrices representing the two inputs
have the same data format (rows represent models, columns represent nodes,
and each value is a number in the [0,1] interval).
}
\section{Details}{

So, if a node has a value close to -1 it means that on average,
this node's boolean equation has the \strong{AND NOT} link operator in the
models that predicted the specified synergy while a value closer to 1 means that
the node's boolean equation has mostly the \strong{OR NOT} link operator
in these models. A value closer to 0 indicates that the link operator in
the node's boolean equation is \strong{not so much different} between the
models that predicted the synergy and those that did not and so it won't not
be a node of interest when searching for \emph{synergy biomarkers} - nodes
whose parameterization (value of the link operator) affects the manifestation
of synergy. A value exactly equal to 0 can also mean that this node didn't
not have a link operator in its boolean equation (making it thus a non-important
node with regard to the parameterization).
}

\seealso{
Other average data difference functions: \code{\link{get_avg_activity_diff_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_based_on_synergy_set_cmp}},
  \code{\link{get_avg_activity_diff_based_on_tp_predictions}},
  \code{\link{get_avg_activity_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_mat_based_on_tp_predictions}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}}
}
\concept{average data difference functions}
