% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{summary.em}
\alias{summary.em}
\title{Summaries of fitted finite mixture models using EM algorithm}
\usage{
\method{summary}{em}(object, ...)
}
\arguments{
\item{object}{Output from \code{em}, representing a fitted model using EM algorithm.}

\item{...}{other arguments used.}
}
\value{
An object of class `summary.em` is a list containing at least the following components:
 \code{call} the matched call.
 \code{coefficients}
 \code{pi} the prior probabilities.
 \code{latent} number of the latent classes.
 \code{ll} log-likelihood value.
 \code{sum.models} summaries of models generated by `summary()` of models from each class.
 \code{df} degree of freedom.
 \code{obs} number of observations.
 \code{AIC} the Akaike information criterion.
 \code{BIC} the Bayesian information criterion.
 \code{concomitant} a list of the concomitant model. It is empty if no concomitant model is used.
 \code{concomitant.summary} summaries of the concomitant model generated by `summary()`.
}
\description{
Summaries of fitted finite mixture models using EM algorithm
}
