% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_raster.R
\name{get_elev_raster}
\alias{get_elev_raster}
\title{Get Raster Elevation}
\usage{
get_elev_raster(locations, z, prj = NULL, src = c("aws"),
  expand = NULL, clip = c("tile", "bbox", "locations"),
  verbose = TRUE, ...)
}
\arguments{
\item{locations}{Either a \code{data.frame} of x (long) and y (lat), an 
\code{sp}, or \code{raster} object as input.}

\item{z}{The zoom level to return.  The zoom ranges from 1 to 14.  Resolution
of the resultant raster is determined by the zoom and latitude.  For 
details on zoom and resolution see the documentation from Mapzen at 
\url{https://mapzen.com/documentation/terrain-tiles/data-sources/#what-is-the-ground-resolution}}

\item{prj}{A PROJ.4 string defining the projection of the locations argument. 
If a \code{sp} or \code{raster} object is provided, the PROJ.4 
string will be taken from that.  This argument is required for a 
\code{data.frame} of locations."}

\item{src}{A character indicating which API to use, currently only 
"aws" is used.}

\item{expand}{A numeric value of a distance, in map units, used to expand the
bounding box that is used to fetch the terrain tiles. This can 
be used for features that fall close to the edge of a tile and 
additional area around the feature is desired. Default is NULL.}

\item{clip}{A character value used to determine clipping of returned DEM.
The default value is "tile" which returns the full tiles.  Other 
options are "bbox" which returns the DEM clipped to the bounding 
box of the original locations (or expanded bounding box if used), 
or "locations" if the spatials data (e.g. polygons) in the input 
locations should be used to clip the DEM.  Locations are not used 
to clip input point datasets.  Instead the bounding box is used.}

\item{verbose}{Toggles on and off the note about units and coordinate 
reference system.}

\item{...}{Extra arguments to pass to \code{httr::GET} via a named vector, 
\code{config}.   See
\code{\link{get_aws_terrain}} for more details.}
}
\value{
Function returns a \code{SpatialPointsDataFrame} in the projection 
        specified by the \code{prj} argument.
}
\description{
Several web services provide access to raster elevation. Currently, this 
function provides access to the Mapzen Terrain Service The function 
accepts a \code{data.frame} of x (long) and y (lat), an 
\code{sp}, or \code{raster} object as input.  A \code{raster} object is 
returned.
}
\details{
Currently, the \code{get_elev_raster} utilizes only the 
         Amazon Web Services 
         (\url{https://aws.amazon.com/public-datasets/terrain/}) terrain 
         tiles.  Versions of \code{elevatr} 0.1.4 or earlier had options for 
         the Mapzen terrain tiles.  Mapzen data is no longer available.  
         Support for the replacment Nextzen tiles is not currently available
         
         The terrain data is provided via x, y, and z tiles (see 
         \url{http://wiki.openstreetmap.org/wiki/Slippy_map_tilenames} for 
         details.) The x and y are determined from the bounding box of the 
         object submitted for \code{locations} argument, and the z argument 
         must be specified by the user.
}
\examples{
\dontrun{
loc_df <- data.frame(x = runif(6,min=sp::bbox(lake)[1,1], 
                               max=sp::bbox(lake)[1,2]),
                     y = runif(6,min=sp::bbox(lake)[2,1], 
                               max=sp::bbox(lake)[2,2]))
x <- get_elev_raster(locations = loc_df, prj = sp::proj4string(lake), z=10)

data(lake)
x <- get_elev_raster(lake, z = 12)
}

}
