% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize.R
\name{tokenize}
\alias{tokenize}
\alias{tokenize_tbl}
\alias{tokenize_tidytext}
\alias{tokenize_tidy}
\title{Simple version of tokenizer function.}
\usage{
tokenize(text, match_option = Match$ALL, stopwords = TRUE)

tokenize_tbl(text, match_option = Match$ALL, stopwords = TRUE)

tokenize_tidytext(text, match_option = Match$ALL, stopwords = TRUE)

tokenize_tidy(text, match_option = Match$ALL, stopwords = TRUE)
}
\arguments{
\item{text}{target text.}

\item{match_option}{\code{\link{Match}}: use Match. Default is Match$ALL}

\item{stopwords}{stopwords option. Default is TRUE which is
to use embaded stopwords dictionany.
If FALSE, use not embaded stopwords dictionany.
If char: path of dictionary txt file, use file.
If \code{\link{Stopwords}} class, use it.
If not valid value, work same as FALSE.
Check \code{\link[=analyze]{analyze()}} how to use stopwords param.}
}
\value{
list type of result.
}
\description{
Simple version of tokenizer function.
}
\examples{
\dontrun{
  tokenize("Test text.")
  tokenize("Please use Korean.", Match$ALL_WITH_NORMALIZING)
}
}
