% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_remover.R
\name{type_remover}
\alias{type_remover}
\title{Utility function to remove 'type' from bulk load files}
\usage{
type_remover(file)
}
\arguments{
\item{file}{(character) a file path, required}
}
\value{
a file path for a temporary file with the types removed
}
\description{
Types are being removed from Elasticsearch. This little function
aims to help remove "_type" fields from bulk newline-delimited JSON
files. See Details.
}
\details{
Looks for any lines that have an "index" key, then drops
any "_type" keys in the hash given by the "index" key.

You can of course manually modify these files as an alternative,
in a text editor or with command line tools like sed, etc.
}
\examples{
\dontrun{
z <- system.file("examples/omdb.json", package = "elastic")
readLines(z, 6)
ff <- type_remover(z)
readLines(ff, 6)
unlink(ff)
}
}
