% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{indices}
\alias{indices}
\alias{index_get}
\alias{index_exists}
\alias{index_delete}
\alias{index_create}
\alias{index_recreate}
\alias{index_close}
\alias{index_open}
\alias{index_stats}
\alias{index_settings}
\alias{index_settings_update}
\alias{index_segments}
\alias{index_recovery}
\alias{index_optimize}
\alias{index_forcemerge}
\alias{index_upgrade}
\alias{index_analyze}
\alias{index_flush}
\alias{index_clear_cache}
\title{Index API operations}
\usage{
index_get(conn, index = NULL, features = NULL, raw = FALSE,
  verbose = TRUE, ...)

index_exists(conn, index, ...)

index_delete(conn, index, raw = FALSE, verbose = TRUE, ...)

index_create(conn, index = NULL, body = NULL, raw = FALSE,
  verbose = TRUE, ...)

index_recreate(conn, index = NULL, body = NULL, raw = FALSE,
  verbose = TRUE, ...)

index_close(conn, index, ...)

index_open(conn, index, ...)

index_stats(conn, index = NULL, metric = NULL,
  completion_fields = NULL, fielddata_fields = NULL, fields = NULL,
  groups = NULL, level = "indices", ...)

index_settings(conn, index = "_all", ...)

index_settings_update(conn, index = NULL, body, ...)

index_segments(conn, index = NULL, ...)

index_recovery(conn, index = NULL, detailed = FALSE,
  active_only = FALSE, ...)

index_optimize(conn, index = NULL, max_num_segments = NULL,
  only_expunge_deletes = FALSE, flush = TRUE, wait_for_merge = TRUE,
  ...)

index_forcemerge(conn, index = NULL, max_num_segments = NULL,
  only_expunge_deletes = FALSE, flush = TRUE, ...)

index_upgrade(conn, index = NULL, wait_for_completion = FALSE, ...)

index_analyze(conn, text = NULL, field = NULL, index = NULL,
  analyzer = NULL, tokenizer = NULL, filters = NULL,
  char_filters = NULL, body = list(), ...)

index_flush(conn, index = NULL, force = FALSE, full = FALSE,
  wait_if_ongoing = FALSE, ...)

index_clear_cache(conn, index = NULL, filter = FALSE,
  filter_keys = NULL, fielddata = FALSE, query_cache = FALSE,
  id_cache = FALSE, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{(character) A character vector of index names}

\item{features}{(character) A single feature. One of settings, mappings, or
aliases}

\item{raw}{If \code{TRUE} (default), data is parsed to list. If FALSE, then raw JSON.}

\item{verbose}{If \code{TRUE} (default) the url call used printed to console.}

\item{...}{Curl args passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{body}{Query, either a list or json.}

\item{metric}{(character) A character vector of metrics to display. Possible
values: "_all", "completion", "docs", "fielddata", "filter_cache", "flush",
"get", "id_cache", "indexing", "merge", "percolate", "refresh", "search",
"segments", "store", "warmer".}

\item{completion_fields}{(character) A character vector of fields for completion metric
(supports wildcards)}

\item{fielddata_fields}{(character) A character vector of fields for fielddata metric
(supports wildcards)}

\item{fields}{(character) Fields to add.}

\item{groups}{(character) A character vector of search groups for search statistics.}

\item{level}{(character) Return stats aggregated on "cluster", "indices" (default) or "shards"}

\item{detailed}{(logical) Whether to display detailed information about shard recovery.
Default: \code{FALSE}}

\item{active_only}{(logical) Display only those recoveries that are currently on-going.
Default: \code{FALSE}}

\item{max_num_segments}{(character) The number of segments the index should be merged into.
Default: "dynamic"}

\item{only_expunge_deletes}{(logical) Specify whether the operation should only expunge
deleted documents}

\item{flush}{(logical) Specify whether the index should be flushed after performing the
operation. Default: \code{TRUE}}

\item{wait_for_merge}{(logical) Specify whether the request should block until the merge
process is finished. Default: \code{TRUE}}

\item{wait_for_completion}{(logical) Should the request wait for the upgrade to complete.
Default: \code{FALSE}}

\item{text}{The text on which the analysis should be performed (when request body is not used)}

\item{field}{Use the analyzer configured for this field (instead of passing the analyzer name)}

\item{analyzer}{The name of the analyzer to use}

\item{tokenizer}{The name of the tokenizer to use for the analysis}

\item{filters}{A character vector of filters to use for the analysis}

\item{char_filters}{A character vector of character filters to use for the analysis}

\item{force}{(logical) Whether a flush should be forced even if it is not necessarily needed
ie. if no changes will be committed to the index.}

\item{full}{(logical) If set to TRUE a new index writer is created and settings that have been
changed related to the index writer will be refreshed.}

\item{wait_if_ongoing}{If TRUE, the flush operation will block until the flush can be executed
if another flush operation is already executing. The default is false and will cause an
exception to be thrown on the shard level if another flush operation is already running.}

\item{filter}{(logical) Clear filter caches}

\item{filter_keys}{(character) A vector of keys to clear when using the \code{filter_cache}
parameter (default: all)}

\item{fielddata}{(logical) Clear field data}

\item{query_cache}{(logical) Clear query caches}

\item{id_cache}{(logical) Clear ID caches for parent/child}
}
\description{
Index API operations
}
\details{
\strong{index_analyze}:
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-analyze.html}
This method can accept a string of text in the body, but this function passes it as a
parameter in a GET request to simplify.

\strong{index_flush}:
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-flush.html}
From the ES website: The flush process of an index basically frees memory from the index by
flushing data to the index storage and clearing the internal transaction log. By default,
Elasticsearch uses memory heuristics in order to automatically trigger flush operations as
required in order to clear memory.

\strong{index_status}: The API endpoint for this function was deprecated in
Elasticsearch \code{v1.2.0}, and will likely be removed soon. Use \code{\link[=index_recovery]{index_recovery()}}
instead.

\strong{index_settings_update}: There are a lot of options you can change with this
function. See
https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-update-settings.html
for all the options.

\strong{index settings}: See
https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules.html
for the \emph{static} and \emph{dynamic} settings you can set on indices.
}
\section{Mappings}{

The "keyword" type is not supported in Elasticsearch < v5. If you do use a mapping
with "keyword" type in Elasticsearch < v5 \code{\link[=index_create]{index_create()}} should fail.
}

\examples{
\dontrun{
# connection setup
(x <- connect())

# get information on an index
index_get(x, index='shakespeare')
## this one is the same as running index_settings('shakespeare')
index_get(x, index='shakespeare', features='settings')
index_get(x, index='shakespeare', features='mappings')
index_get(x, index='shakespeare', features='alias')

# check for index existence
index_exists(x, index='shakespeare')
index_exists(x, index='plos')

# create an index
if (index_exists(x, 'twitter')) index_delete(x, 'twitter')
index_create(x, index='twitter')
if (index_exists(x, 'things')) index_delete(x, 'things')
index_create(x, index='things')
if (index_exists(x, 'plos')) index_delete(x, 'plos')
index_create(x, index='plos')

# re-create an index
index_recreate(x, "deer")
index_recreate(x, "deer", verbose = FALSE)

# delete an index
if (index_exists(x, 'plos')) index_delete(x, index='plos')

## with a body
body <- '{
 "settings" : {
  "index" : {
    "number_of_shards" : 3,
    "number_of_replicas" : 2
   }
 }
}'
if (index_exists(x, 'alsothat')) index_delete(x, 'alsothat')
index_create(x, index='alsothat', body = body)
## with read only
body <- '{
 "settings" : {
  "index" : {
    "blocks" : {
      "read_only" : true
    }
   }
 }
}'
# index_create(x, index='myindex', body = body)
# then this delete call should fail with something like:
## > Error: 403 - blocked by: [FORBIDDEN/5/index read-only (api)]
# index_delete(x, index='myindex')

## with mappings
body <- '{
 "mappings": {
   "record": {
     "properties": {
       "location" : {"type" : "geo_point"}
      }
   }
 }
}'
if (!index_exists(x, 'gbifnewgeo')) index_create(x, index='gbifnewgeo', body=body)
gbifgeo <- system.file("examples", "gbif_geosmall.json", package = "elastic")
docs_bulk(x, gbifgeo)

# close an index
index_create(x, 'plos')
index_close(x, 'plos')

# open an index
index_open(x, 'plos')

# Get stats on an index
index_stats(x, 'plos')
index_stats(x, c('plos','gbif'))
index_stats(x, c('plos','gbif'), metric='refresh')
index_stats(x, metric = "indexing")
index_stats(x, 'shakespeare', metric='completion')
index_stats(x, 'shakespeare', metric='completion', completion_fields = "completion")
index_stats(x, 'shakespeare', metric='fielddata')
index_stats(x, 'shakespeare', metric='fielddata', fielddata_fields = "evictions")
index_stats(x, 'plos', level="indices")
index_stats(x, 'plos', level="cluster")
index_stats(x, 'plos', level="shards")

# Get segments information that a Lucene index (shard level) is built with
index_segments(x)
index_segments(x, 'plos')
index_segments(x, c('plos','gbif'))

# Get recovery information that provides insight into on-going index shard recoveries
index_recovery(x)
index_recovery(x, 'plos')
index_recovery(x, c('plos','gbif'))
index_recovery(x, "plos", detailed = TRUE)
index_recovery(x, "plos", active_only = TRUE)

# Optimize an index, or many indices
if (x$es_ver() < 500) {
  ### ES < v5 - use optimize
  index_optimize(x, 'plos')
  index_optimize(x, c('plos','gbif'))
  index_optimize(x, 'plos')
} else {
  ### ES > v5 - use forcemerge
  index_forcemerge(x, 'plos')
}

# Upgrade one or more indices to the latest format. The upgrade process converts any
# segments written with previous formats.
if (x$es_ver() < 500) {
  index_upgrade(x, 'plos')
  index_upgrade(x, c('plos','gbif'))
}

# Performs the analysis process on a text and return the tokens breakdown
# of the text
index_analyze(x, text = 'this is a test', analyzer='standard')
index_analyze(x, text = 'this is a test', analyzer='whitespace')
index_analyze(x, text = 'this is a test', analyzer='stop')
index_analyze(x, text = 'this is a test', tokenizer='keyword',
  filters='lowercase')
index_analyze(x, text = 'this is a test', tokenizer='keyword',
  filters='lowercase', char_filters='html_strip')
index_analyze(x, text = 'this is a test', index = 'plos',
  analyzer="standard")
index_analyze(x, text = 'this is a test', index = 'shakespeare',
  analyzer="standard")

## NGram tokenizer
body <- '{
        "settings" : {
             "analysis" : {
                 "analyzer" : {
                     "my_ngram_analyzer" : {
                         "tokenizer" : "my_ngram_tokenizer"
                     }
                 },
                 "tokenizer" : {
                     "my_ngram_tokenizer" : {
                         "type" : "nGram",
                         "min_gram" : "2",
                         "max_gram" : "3",
                         "token_chars": [ "letter", "digit" ]
                     }
                 }
             }
      }
}'
if (index_exists(x, "shakespeare2")) index_delete(x, "shakespeare2")
tokenizer_set(x, index = "shakespeare2", body=body)
index_analyze(x, text = "art thouh", index = "shakespeare2",
  analyzer='my_ngram_analyzer')

# Explicitly flush one or more indices.
index_flush(x, index = "plos")
index_flush(x, index = "shakespeare")
index_flush(x, index = c("plos","shakespeare"))
index_flush(x, index = "plos", wait_if_ongoing = TRUE)
index_flush(x, index = "plos", verbose = TRUE)

# Clear either all caches or specific cached associated with one ore more indices.
index_clear_cache(x)
index_clear_cache(x, index = "plos")
index_clear_cache(x, index = "shakespeare")
index_clear_cache(x, index = c("plos","shakespeare"))
index_clear_cache(x, filter = TRUE)

# Index settings
## get settings
index_settings(x)
index_settings(x, "_all")
index_settings(x, 'gbif')
index_settings(x, c('gbif','plos'))
index_settings(x, '*s')
## update settings
if (index_exists(x, 'foobar')) index_delete(x, 'foobar')
index_create(x, "foobar")
settings <- list(index = list(number_of_replicas = 4))
index_settings_update(x, "foobar", body = settings)
index_get(x, "foobar")$foobar$settings
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices.html}
}
\author{
Scott Chamberlain \href{mailto:myrmecocystus@gmail.com}{myrmecocystus@gmail.com}
}
