% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.r
\name{cat}
\alias{cat}
\alias{cat_}
\alias{cat_aliases}
\alias{cat_allocation}
\alias{cat_count}
\alias{cat_segments}
\alias{cat_health}
\alias{cat_indices}
\alias{cat_master}
\alias{cat_nodes}
\alias{cat_nodeattrs}
\alias{cat_pending_tasks}
\alias{cat_plugins}
\alias{cat_recovery}
\alias{cat_thread_pool}
\alias{cat_shards}
\alias{cat_fielddata}
\title{Use the cat Elasticsearch api.}
\usage{
cat_(parse = FALSE, ...)

cat_aliases(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_allocation(verbose = FALSE, h = NULL, help = FALSE, bytes = FALSE,
  parse = FALSE, ...)

cat_count(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_segments(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_health(verbose = FALSE, h = NULL, help = FALSE, bytes = FALSE,
  parse = FALSE, ...)

cat_indices(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_master(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_nodes(verbose = FALSE, h = NULL, help = FALSE, bytes = FALSE,
  parse = FALSE, ...)

cat_nodeattrs(verbose = FALSE, h = NULL, help = FALSE, bytes = FALSE,
  parse = FALSE, ...)

cat_pending_tasks(verbose = FALSE, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_plugins(verbose = FALSE, h = NULL, help = FALSE, bytes = FALSE,
  parse = FALSE, ...)

cat_recovery(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_thread_pool(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_shards(verbose = FALSE, index = NULL, h = NULL, help = FALSE,
  bytes = FALSE, parse = FALSE, ...)

cat_fielddata(verbose = FALSE, index = NULL, fields = NULL, h = NULL,
  help = FALSE, bytes = FALSE, parse = FALSE, ...)
}
\arguments{
\item{parse}{(logical) Parse to a data.frame or not. Default: \code{FALSE}}

\item{...}{Curl args passed on to \code{\link[httr:GET]{httr::GET()}}}

\item{verbose}{(logical) If \code{TRUE} (default) the url call used printed to console}

\item{index}{(character) Index name}

\item{h}{(character) Fields to return}

\item{help}{(logical) Output available columns, and their meanings}

\item{bytes}{(logical) Give numbers back machine friendly. Default: \code{FALSE}}

\item{fields}{(character) Fields to return, only used with \code{fielddata}}
}
\description{
Use the cat Elasticsearch api.
}
\details{
See \url{https://www.elastic.co/guide/en/elasticsearch/reference/current/cat.html}
for the cat API documentation.

Note how \code{\link[=cat_]{cat_()}} has an underscore at the end to avoid conflict with the function
\code{\link[base:cat]{base::cat()}} in base R.
}
\examples{
\dontrun{
# list Elasticsearch cat endpoints
cat_()

# Do other cat operations
cat_aliases()
cat_aliases(index='plos')
cat_allocation()
cat_allocation(verbose=TRUE)
cat_count()
cat_count(index='plos')
cat_count(index='gbif')
cat_segments()
cat_segments(index='gbif')
cat_health()
cat_indices()
cat_master()
cat_nodes()
# cat_nodeattrs() # not available in older ES versions
cat_pending_tasks()
cat_plugins()
cat_recovery(verbose=TRUE)
cat_recovery(index='gbif')
cat_thread_pool()
cat_thread_pool(verbose=TRUE)
cat_shards()
cat_fielddata()
cat_fielddata(fields='body')

# capture cat data into a data.frame
cat_(parse = TRUE)
cat_indices(parse = TRUE)
cat_indices(parse = TRUE, verbose = TRUE)
cat_count(parse = TRUE)
cat_count(parse = TRUE, verbose = TRUE)
cat_health(parse = TRUE)
cat_health(parse = TRUE, verbose = TRUE)

# Get help - what does each column mean
head(cat_indices(help = TRUE, parse = TRUE))
cat_health(help = TRUE, parse = TRUE)
head(cat_nodes(help = TRUE, parse = TRUE))

# Get back only certain fields
cat_nodes()
cat_nodes(h = c('ip','port','heapPercent','name'))
cat_nodes(h = c('id', 'ip', 'port', 'v', 'm'))
cat_indices(verbose = TRUE)
cat_indices(verbose = TRUE, h = c('index','docs.count','store.size'))

# Get back machine friendly numbers instead of the normal human friendly
cat_indices(verbose = TRUE, bytes = TRUE)

# Curl options
library("httr")
cat_count(config=verbose())
}
}
