% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_preprocessing.R
\name{dedupe_precincts}
\alias{dedupe_precincts}
\title{Remove or identify duplicated precincts}
\usage{
dedupe_precincts(data, id_cols, verbose = TRUE)
}
\arguments{
\item{data}{A data.frame() object containing precinct-level turnout data by
race and candidate}

\item{id_cols}{The name or index of the column in the data containing
unique precinct identifiers. Can pass multiple column names or indices in
a vector if precincts are identified over multiple columns
(eg. c("precinctid", "countyid")).}

\item{verbose}{A boolean. If true, messages are returned describing actions
taken by the function.}
}
\value{
A new dataframe without duplicated rows, and (if any) a boolean
column identifying duplicated precincts for further investigation.
}
\description{
Removes any rows in the dataset that are fully duplicated. If necessary, adds
' duplicates' column indicating where precincts appear duplicated, for manual
inspection by the user
}
\author{
Ari Decter-Frain <agd75@cornell.edu>
}
