% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.aftreg.R
\name{plot.aftreg}
\alias{plot.aftreg}
\title{Plots output from an AFT regression}
\usage{
\method{plot}{aftreg}(x, fn = c("haz", "cum", "den", "sur"),
  main = NULL, xlim = NULL, ylim = NULL, xlab = "Duration",
  ylab = "", col, lty, printLegend = TRUE, new.data = x$means, ...)
}
\arguments{
\item{x}{A \code{aftreg} object}

\item{fn}{Which functions shoud be plotted! Default is all. They will scroll
by, so you have to take care of explicitly what you want to be produced.
See, eg, \code{par(mfrow = ...)}}

\item{main}{Header for the plot}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{xlab}{x label}

\item{ylab}{y label}

\item{col}{Colors?}

\item{lty}{Line types?}

\item{printLegend}{Should legend be printed? Default is yes.}

\item{new.data}{At which covariate values?}

\item{\dots}{Extra parameters passed to 'plot'}
}
\value{
No return value.
}
\description{
Just a simple plot of the hazard (cumulative hazard, density, survival)
functions for each stratum.
}
\details{
The plot is drawn at the mean values of the covariates, by default.
}
\examples{

y <- rllogis(40, shape = 1, scale = 1)
x <- rep(c(1,1,2,2), 10)
fit <- aftreg(Surv(y, rep(1, 40)) ~ x, dist = "loglogistic")
plot(fit)

}
\seealso{
\code{\link{aftreg}}
}
\author{
Göran Broström
}
\keyword{dplot}
\keyword{survival}
