% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_frame.r
\name{ggarrange}
\alias{ggarrange}
\title{ggarrange}
\usage{
ggarrange(..., plots = list(...), nrow = NULL, ncol = NULL,
  widths = NULL, heights = NULL, byrow = TRUE, top = NULL,
  bottom = NULL, left = NULL, right = NULL, padding = unit(0.5, "line"),
  clip = "on", draw = TRUE, newpage = TRUE, debug = FALSE)
}
\arguments{
\item{...}{ggplot objects}

\item{plots}{list of ggplots}

\item{nrow}{number of rows}

\item{ncol}{number of columns}

\item{widths}{list of requested widths}

\item{heights}{list of requested heights}

\item{byrow}{logical, fill by rows}

\item{top}{optional string, or grob}

\item{bottom}{optional string, or grob}

\item{left}{optional string, or grob}

\item{right}{optional string, or grob}

\item{padding}{unit of length one, margin around annotations}

\item{clip}{argument of gtable}

\item{draw}{logical: draw or return a grob}

\item{newpage}{logical: draw on a new page}

\item{debug}{logical, show layout with thin lines}
}
\value{
gtable of aligned plots
}
\description{
ggarrange
}
\examples{
library(grid)
p1 <- ggplot(mtcars, aes(mpg, wt, colour = factor(cyl))) +
  geom_point() 
p2 <- ggplot(mtcars, aes(mpg, wt, colour = factor(cyl))) +
  geom_point() + facet_wrap( ~ cyl, ncol=2, scales = "free") +
  guides(colour="none") +
  theme()
grid.newpage()
grid.draw(ggarrange(p1, p2, widths = c(2,1)))
}
