% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret.R
\name{rules}
\alias{rules}
\alias{is.rules}
\title{Interpretation Grid}
\usage{
rules(values, labels = NULL, name = NULL, right = TRUE)

is.rules(x)
}
\arguments{
\item{values}{Vector of reference values (edges defining categories or
critical values).}

\item{labels}{Labels associated with each category. If \code{NULL}, will try to
infer it from \code{values} (if it is a named vector or a list), otherwise, will
return the breakpoints.}

\item{name}{Name of the set of rules (will be printed).}

\item{right}{logical, for threshold-type rules, indicating if the thresholds
themselves should be included in the interval to the right (lower values)
or in the interval to the left (higher values).}

\item{x}{An arbitrary R object.}
}
\description{
Create a container for interpretation rules of thumb. Usually used in conjunction with \link{interpret}.
}
\examples{
rules(c(0.05), c("significant", "not significant"), right = FALSE)
rules(c(0.2, 0.5, 0.8), c("small", "medium", "large"))
rules(c("small" = 0.2, "medium" = 0.5), name = "Cohen's Rules")
}
\seealso{
interpret
}
