% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{eem_cut}
\alias{eem_cut}
\title{Cut emission and/or excitation wavelengths from EEMs}
\usage{
eem_cut(eem, ex, em, exact = TRUE, fill_with_na = FALSE)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{ex}{A numeric vector of excitation wavelengths to be removed.}

\item{em}{A numeric vector of emission wavelengths to be removed.}

\item{exact}{Logical. If TRUE, only wavelengths matching \code{em} and/or
\code{ex} will be removed. If FALSE, all wavelengths in the range of
\code{em} and/or \code{ex} will be removed.}

\item{fill_with_na}{Logical. If TRUE, fluorescence values at specified
wavelengths will be replaced with NA. If FALSE, these values will be
removed.}
}
\value{
An object of class \code{eemlist}.
}
\description{
Cut emission and/or excitation wavelengths from EEMs
}
\examples{
# Open the fluorescence eem
file <- system.file("extdata/cary/scans_day_1/", "sample1.csv", package = "eemR")

eem <- eem_read(file, import_function = "cary")
plot(eem)

# Cut few excitation wavelengths
eem <- eem_cut(eem, ex = c(220, 225, 230, 230))
plot(eem)

eem <- eem_read(file, import_function = "cary")
eem <- eem_cut(eem, em = 350:400, fill_with_na = TRUE)
plot(eem)
}
