% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{plot.eemlist}
\alias{plot.eemlist}
\title{Surface plot of eem}
\usage{
\method{plot}{eemlist}(x, which = 1, interactive = FALSE,
  show_peaks = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{eemlist}.}

\item{which}{An integer representing the index of eem to be plotted.}

\item{interactive}{If \code{TRUE} a Shiny app will start to visualize EEMS.}

\item{show_peaks}{Boolean indicating if Cobble's peaks should be displayed on
the surface plot. Default is FALSE.}

\item{...}{Extra arguments for \code{image.plot}.}
}
\description{
Surface plot of eem
}
\examples{
folder <- system.file("extdata/cary/scans_day_1/", package = "eemR")
eem <- eem_read(folder)

plot(eem, which = 3)
}

